/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjectFactory;
import java.io.Closeable;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;

public class WeakObjectPool<T extends Mutable>
implements Closeable {
    private final ArrayDeque<T> cache = new ArrayDeque();
    private final ObjectFactory<T> factory;
    private final int size;

    public WeakObjectPool(@NotNull ObjectFactory<T> factory, int size) {
        this.factory = factory;
        this.size = size;
        this.fill();
    }

    @Override
    public void close() {
        while (this.cache.size() > 0) {
            Misc.free(this.cache.pop());
        }
    }

    public T pop() {
        Mutable obj = (Mutable)this.cache.poll();
        return (T)(obj == null ? (Mutable)this.factory.newInstance() : obj);
    }

    public void push(T obj) {
        assert (obj != null);
        obj.clear();
        this.cache.push(obj);
    }

    private void fill() {
        for (int i = 0; i < this.size; ++i) {
            this.cache.add(this.factory.newInstance());
        }
    }
}

