/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime;

import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.TimeZoneRuleFactory;
import java.text.DateFormatSymbols;
import java.util.Locale;

public class DateLocaleFactory {
    public static final DateLocaleFactory INSTANCE = new DateLocaleFactory(TimeZoneRuleFactory.INSTANCE);
    private final CharSequenceObjHashMap<DateLocale> dateLocales = new CharSequenceObjHashMap();

    public DateLocaleFactory(TimeZoneRuleFactory timeZoneRuleFactory) {
        CharSequenceHashSet cache = new CharSequenceHashSet();
        for (Locale l : Locale.getAvailableLocales()) {
            String tag = l.toLanguageTag();
            if ("und".equals(tag)) {
                tag = "";
            }
            this.dateLocales.put(tag, new DateLocale(new DateFormatSymbols(l), timeZoneRuleFactory, cache));
            cache.clear();
        }
    }

    public DateLocale getLocale(CharSequence id) {
        return this.dateLocales.get(id);
    }
}

