/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime.microtime;

import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.AbstractDateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.CharSink;

public class GenericTimestampFormat
extends AbstractDateFormat {
    private final IntList compiledOps;
    private final ObjList<String> delimiters;

    public GenericTimestampFormat(IntList compiledOps, ObjList<String> delimiters) {
        this.compiledOps = compiledOps;
        this.delimiters = delimiters;
    }

    @Override
    public void format(long micros, DateLocale locale, CharSequence timeZoneName, CharSink sink) {
        int day = -1;
        int month = -1;
        int year = Integer.MIN_VALUE;
        int hour = -1;
        int minute = -1;
        int second = -1;
        int dayOfWeek = -1;
        boolean leap = false;
        int millis = -1;
        int micros0 = -1;
        int n = this.compiledOps.size();
        block35: for (int i = 0; i < n; ++i) {
            int op = this.compiledOps.getQuick(i);
            switch (op) {
                case 14: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    TimestampFormatUtils.appendAmPm(sink, hour, locale);
                    continue block35;
                }
                case 39: 
                case 149: {
                    if (micros0 == -1) {
                        micros0 = Timestamps.getMicrosOfSecond(micros);
                    }
                    sink.put(micros0);
                    continue block35;
                }
                case 49: {
                    if (micros0 == -1) {
                        micros0 = Timestamps.getMicrosOfSecond(micros);
                    }
                    TimestampFormatUtils.append00(sink, micros0);
                    continue block35;
                }
                case 21: 
                case 146: {
                    if (millis == -1) {
                        millis = Timestamps.getMillisOfSecond(micros);
                    }
                    sink.put(millis);
                    continue block35;
                }
                case 31: {
                    if (millis == -1) {
                        millis = Timestamps.getMillisOfSecond(micros);
                    }
                    TimestampFormatUtils.append00(sink, millis);
                    continue block35;
                }
                case 40: 
                case 147: {
                    sink.put(0);
                    continue block35;
                }
                case 50: {
                    TimestampFormatUtils.append00(sink, 0);
                    continue block35;
                }
                case 20: 
                case 145: {
                    if (second == -1) {
                        second = Timestamps.getSecondOfMinute(micros);
                    }
                    sink.put(second);
                    continue block35;
                }
                case 30: {
                    if (second == -1) {
                        second = Timestamps.getSecondOfMinute(micros);
                    }
                    TimestampFormatUtils.append0(sink, second);
                    continue block35;
                }
                case 19: 
                case 144: {
                    if (minute == -1) {
                        minute = Timestamps.getMinuteOfHour(micros);
                    }
                    sink.put(minute);
                    continue block35;
                }
                case 29: {
                    if (minute == -1) {
                        minute = Timestamps.getMinuteOfHour(micros);
                    }
                    TimestampFormatUtils.append0(sink, minute);
                    continue block35;
                }
                case 17: 
                case 142: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    TimestampFormatUtils.appendHour12(sink, hour);
                    continue block35;
                }
                case 34: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    TimestampFormatUtils.appendHour12Padded(sink, hour);
                    continue block35;
                }
                case 18: 
                case 143: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    TimestampFormatUtils.appendHour121(sink, hour);
                    continue block35;
                }
                case 35: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    TimestampFormatUtils.appendHour121Padded(sink, hour);
                    continue block35;
                }
                case 15: 
                case 140: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    sink.put(hour);
                    continue block35;
                }
                case 32: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    TimestampFormatUtils.append0(sink, hour);
                    continue block35;
                }
                case 16: 
                case 141: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    sink.put(hour + 1);
                    continue block35;
                }
                case 33: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    TimestampFormatUtils.append0(sink, hour + 1);
                    continue block35;
                }
                case 9: 
                case 139: {
                    if (day == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Timestamps.getYear(micros);
                            leap = Timestamps.isLeapYear(year);
                        }
                        if (month == -1) {
                            month = Timestamps.getMonthOfYear(micros, year, leap);
                        }
                        day = Timestamps.getDayOfMonth(micros, year, month, leap);
                    }
                    sink.put(day);
                    continue block35;
                }
                case 10: {
                    if (day == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Timestamps.getYear(micros);
                            leap = Timestamps.isLeapYear(year);
                        }
                        if (month == -1) {
                            month = Timestamps.getMonthOfYear(micros, year, leap);
                        }
                        day = Timestamps.getDayOfMonth(micros, year, month, leap);
                    }
                    TimestampFormatUtils.append0(sink, day);
                    continue block35;
                }
                case 12: {
                    if (dayOfWeek == -1) {
                        dayOfWeek = Timestamps.getDayOfWeekSundayFirst(micros);
                    }
                    sink.put(locale.getWeekday(dayOfWeek));
                    continue block35;
                }
                case 11: {
                    if (dayOfWeek == -1) {
                        dayOfWeek = Timestamps.getDayOfWeekSundayFirst(micros);
                    }
                    sink.put(locale.getShortWeekday(dayOfWeek));
                    continue block35;
                }
                case 13: {
                    if (dayOfWeek == -1) {
                        dayOfWeek = Timestamps.getDayOfWeekSundayFirst(micros);
                    }
                    sink.put(dayOfWeek);
                    continue block35;
                }
                case 5: 
                case 135: {
                    if (month == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Timestamps.getYear(micros);
                            leap = Timestamps.isLeapYear(year);
                        }
                        month = Timestamps.getMonthOfYear(micros, year, leap);
                    }
                    sink.put(month);
                    continue block35;
                }
                case 6: {
                    if (month == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Timestamps.getYear(micros);
                            leap = Timestamps.isLeapYear(year);
                        }
                        month = Timestamps.getMonthOfYear(micros, year, leap);
                    }
                    TimestampFormatUtils.append0(sink, month);
                    continue block35;
                }
                case 7: {
                    if (month == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Timestamps.getYear(micros);
                            leap = Timestamps.isLeapYear(year);
                        }
                        month = Timestamps.getMonthOfYear(micros, year, leap);
                    }
                    sink.put(locale.getShortMonth(month - 1));
                    continue block35;
                }
                case 8: {
                    if (month == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Timestamps.getYear(micros);
                            leap = Timestamps.isLeapYear(year);
                        }
                        month = Timestamps.getMonthOfYear(micros, year, leap);
                    }
                    sink.put(locale.getMonth(month - 1));
                    continue block35;
                }
                case 2: 
                case 132: {
                    if (year == Integer.MIN_VALUE) {
                        year = Timestamps.getYear(micros);
                        leap = Timestamps.isLeapYear(year);
                    }
                    sink.put(year);
                    continue block35;
                }
                case 3: {
                    if (year == Integer.MIN_VALUE) {
                        year = Timestamps.getYear(micros);
                        leap = Timestamps.isLeapYear(year);
                    }
                    TimestampFormatUtils.append0(sink, year % 100);
                    continue block35;
                }
                case 4: {
                    if (year == Integer.MIN_VALUE) {
                        year = Timestamps.getYear(micros);
                        leap = Timestamps.isLeapYear(year);
                    }
                    TimestampFormatUtils.append000(sink, year);
                    continue block35;
                }
                case 1: {
                    if (year == Integer.MIN_VALUE) {
                        year = Timestamps.getYear(micros);
                        leap = Timestamps.isLeapYear(year);
                    }
                    TimestampFormatUtils.appendEra(sink, year, locale);
                    continue block35;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    sink.put(timeZoneName);
                    continue block35;
                }
                default: {
                    sink.put(this.delimiters.getQuick(-op - 1));
                }
            }
        }
    }

    @Override
    public long parse(CharSequence in, int lo, int hi, DateLocale locale) throws NumericException {
        int day = 1;
        int month = 1;
        int year = 1970;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millis = 0;
        int micros = 0;
        int era = 1;
        int timezone = -1;
        long offset = Long.MIN_VALUE;
        int hourType = 2;
        int pos = lo;
        int n = this.compiledOps.size();
        block45: for (int i = 0; i < n; ++i) {
            int op = this.compiledOps.getQuick(i);
            switch (op) {
                case 14: {
                    long l = locale.matchAMPM(in, pos, hi);
                    hourType = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 39: {
                    TimestampFormatUtils.assertRemaining(pos, hi);
                    micros = Numbers.parseInt(in, pos++, pos);
                    continue block45;
                }
                case 49: {
                    TimestampFormatUtils.assertRemaining(pos + 2, hi);
                    micros = Numbers.parseInt(in, pos, pos += 3);
                    continue block45;
                }
                case 149: {
                    long l = Numbers.parseInt000Greedy(in, pos, hi);
                    micros = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 40: {
                    TimestampFormatUtils.assertRemaining(pos++, hi);
                    continue block45;
                }
                case 50: {
                    TimestampFormatUtils.assertRemaining(pos + 2, hi);
                    pos += 3;
                    continue block45;
                }
                case 147: {
                    pos += Numbers.decodeHighInt(Numbers.parseIntSafely(in, pos, hi));
                    continue block45;
                }
                case 21: {
                    TimestampFormatUtils.assertRemaining(pos, hi);
                    millis = Numbers.parseInt(in, pos++, pos);
                    continue block45;
                }
                case 31: {
                    TimestampFormatUtils.assertRemaining(pos + 2, hi);
                    millis = Numbers.parseInt(in, pos, pos += 3);
                    continue block45;
                }
                case 146: {
                    long l = Numbers.parseInt000Greedy(in, pos, hi);
                    millis = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 20: {
                    TimestampFormatUtils.assertRemaining(pos, hi);
                    second = Numbers.parseInt(in, pos++, pos);
                    continue block45;
                }
                case 30: {
                    TimestampFormatUtils.assertRemaining(pos + 1, hi);
                    second = Numbers.parseInt(in, pos, pos += 2);
                    continue block45;
                }
                case 145: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    second = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 19: {
                    TimestampFormatUtils.assertRemaining(pos, hi);
                    minute = Numbers.parseInt(in, pos++, pos);
                    continue block45;
                }
                case 29: {
                    TimestampFormatUtils.assertRemaining(pos + 1, hi);
                    minute = Numbers.parseInt(in, pos, pos += 2);
                    continue block45;
                }
                case 144: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    minute = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 17: {
                    TimestampFormatUtils.assertRemaining(pos, hi);
                    hour = Numbers.parseInt(in, pos++, pos);
                    if (hourType != 2) continue block45;
                    hourType = 0;
                    continue block45;
                }
                case 34: {
                    TimestampFormatUtils.assertRemaining(pos + 1, hi);
                    hour = Numbers.parseInt(in, pos, pos += 2);
                    if (hourType != 2) continue block45;
                    hourType = 0;
                    continue block45;
                }
                case 142: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    hour = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    if (hourType != 2) continue block45;
                    hourType = 0;
                    continue block45;
                }
                case 18: {
                    TimestampFormatUtils.assertRemaining(pos, hi);
                    hour = Numbers.parseInt(in, pos++, pos) - 1;
                    if (hourType != 2) continue block45;
                    hourType = 0;
                    continue block45;
                }
                case 35: {
                    TimestampFormatUtils.assertRemaining(pos + 1, hi);
                    hour = Numbers.parseInt(in, pos, pos += 2) - 1;
                    if (hourType != 2) continue block45;
                    hourType = 0;
                    continue block45;
                }
                case 143: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    hour = Numbers.decodeLowInt(l) - 1;
                    pos += Numbers.decodeHighInt(l);
                    if (hourType != 2) continue block45;
                    hourType = 0;
                    continue block45;
                }
                case 15: {
                    TimestampFormatUtils.assertRemaining(pos, hi);
                    hour = Numbers.parseInt(in, pos++, pos);
                    continue block45;
                }
                case 32: {
                    TimestampFormatUtils.assertRemaining(pos + 1, hi);
                    hour = Numbers.parseInt(in, pos, pos += 2);
                    continue block45;
                }
                case 140: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    hour = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 16: {
                    TimestampFormatUtils.assertRemaining(pos, hi);
                    hour = Numbers.parseInt(in, pos++, pos) - 1;
                    continue block45;
                }
                case 33: {
                    TimestampFormatUtils.assertRemaining(pos + 1, hi);
                    hour = Numbers.parseInt(in, pos, pos += 2) - 1;
                    continue block45;
                }
                case 141: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    hour = Numbers.decodeLowInt(l) - 1;
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 9: {
                    TimestampFormatUtils.assertRemaining(pos, hi);
                    day = Numbers.parseInt(in, pos++, pos);
                    continue block45;
                }
                case 10: {
                    TimestampFormatUtils.assertRemaining(pos + 1, hi);
                    day = Numbers.parseInt(in, pos, pos += 2);
                    continue block45;
                }
                case 139: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    day = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 11: 
                case 12: {
                    long l = locale.matchWeekday(in, pos, hi);
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 13: {
                    TimestampFormatUtils.assertRemaining(pos, hi);
                    Numbers.parseInt(in, pos++, pos);
                    continue block45;
                }
                case 5: {
                    TimestampFormatUtils.assertRemaining(pos, hi);
                    month = Numbers.parseInt(in, pos++, pos);
                    continue block45;
                }
                case 6: {
                    TimestampFormatUtils.assertRemaining(pos + 1, hi);
                    month = Numbers.parseInt(in, pos, pos += 2);
                    continue block45;
                }
                case 135: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    month = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 7: 
                case 8: {
                    long l = locale.matchMonth(in, pos, hi);
                    month = Numbers.decodeLowInt(l) + 1;
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 2: {
                    TimestampFormatUtils.assertRemaining(pos, hi);
                    year = Numbers.parseInt(in, pos++, pos);
                    continue block45;
                }
                case 3: {
                    TimestampFormatUtils.assertRemaining(pos + 1, hi);
                    year = TimestampFormatUtils.adjustYear(Numbers.parseInt(in, pos, pos += 2));
                    continue block45;
                }
                case 4: {
                    if (pos < hi && in.charAt(pos) == '-') {
                        TimestampFormatUtils.assertRemaining(pos + 4, hi);
                        year = -Numbers.parseInt(in, pos + 1, pos += 5);
                        continue block45;
                    }
                    TimestampFormatUtils.assertRemaining(pos + 3, hi);
                    year = Numbers.parseInt(in, pos, pos += 4);
                    continue block45;
                }
                case 132: {
                    long l = TimestampFormatUtils.parseYearGreedy(in, pos, hi);
                    year = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 1: {
                    long l = locale.matchEra(in, pos, hi);
                    era = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    long l = Timestamps.parseOffset(in, pos, hi);
                    if (l == Long.MIN_VALUE) {
                        l = locale.matchZone(in, pos, hi);
                        timezone = Numbers.decodeLowInt(l);
                    } else {
                        offset = (long)Numbers.decodeLowInt(l) * 60000000L;
                    }
                    pos += Numbers.decodeHighInt(l);
                    continue block45;
                }
                default: {
                    String delimiter = this.delimiters.getQuick(-op - 1);
                    int len = delimiter.length();
                    if (len == 1) {
                        TimestampFormatUtils.assertChar(delimiter.charAt(0), in, pos++, hi);
                        continue block45;
                    }
                    pos = TimestampFormatUtils.assertString(delimiter, len, in, pos, hi);
                }
            }
        }
        TimestampFormatUtils.assertNoTail(pos, hi);
        return TimestampFormatUtils.compute(locale, era, year, month, day, hour, minute, second, millis, micros, timezone, offset, hourType);
    }
}

