/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;

public class DirectCharSequence
extends AbstractCharSequence
implements Mutable {
    private long lo;
    private long hi;
    private int len;

    @Override
    public void clear() {
        this.lo = 0L;
        this.hi = 0L;
    }

    @Override
    public int hashCode() {
        if (this.lo == this.hi) {
            return 0;
        }
        int h = 0;
        for (long p = this.lo; p < this.hi; p += 2L) {
            h = 31 * h + Unsafe.getUnsafe().getChar(p);
        }
        return h;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        DirectCharSequence seq = new DirectCharSequence();
        seq.lo = this.lo + (long)start;
        seq.hi = this.lo + (long)end;
        return seq;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        return Unsafe.getUnsafe().getChar(this.lo + ((long)index << 1));
    }

    public DirectCharSequence of(long lo, long hi) {
        this.lo = lo;
        this.hi = hi;
        this.len = (int)((hi - lo) / 2L);
        return this;
    }
}

