/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.MutableCharSink;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class DirectCharSink
extends AbstractCharSink
implements MutableCharSink,
Closeable {
    private long ptr;
    private long capacity;
    private long lo;
    private long hi;

    public DirectCharSink(long capacity) {
        this.ptr = Unsafe.malloc(capacity);
        this.capacity = capacity;
        this.lo = this.ptr;
        this.hi = this.ptr + capacity;
    }

    @Override
    public void clear() {
        this.lo = this.ptr;
    }

    @Override
    public void close() {
        Unsafe.free(this.ptr, this.capacity);
    }

    @Override
    public int length() {
        return (int)(this.lo - this.ptr) / 2;
    }

    @Override
    public char charAt(int index) {
        return Unsafe.getUnsafe().getChar(this.ptr + (long)index * 2L);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSink put(CharSequence cs) {
        if (cs != null) {
            int l = cs.length();
            int l2 = l * 2;
            if (this.lo + (long)l2 >= this.hi) {
                this.resize(Math.max(this.capacity * 2L, (this.lo - this.ptr + (long)l2) * 2L));
            }
            for (int i = 0; i < l; ++i) {
                Unsafe.getUnsafe().putChar(this.lo + (long)i * 2L, cs.charAt(i));
            }
            this.lo += (long)l2;
        }
        return this;
    }

    @Override
    public CharSink put(char c) {
        if (this.lo == this.hi) {
            this.resize(this.capacity * 2L);
        }
        Unsafe.getUnsafe().putChar(this.lo, c);
        this.lo += 2L;
        return this;
    }

    @Override
    public CharSink put(char[] chars, int start, int len) {
        int l2 = len * 2;
        if (this.lo + (long)l2 >= this.hi) {
            this.resize((int)Math.max(this.capacity * 2L, (this.lo - this.ptr + (long)l2) * 2L));
        }
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putChar(this.lo + (long)i * 2L, chars[i + start]);
        }
        this.lo += (long)l2;
        return this;
    }

    @Override
    @NotNull
    public String toString() {
        return AbstractCharSequence.getString(this);
    }

    private void resize(long cap) {
        long temp = Unsafe.realloc(this.ptr, this.capacity, cap);
        int len = (int)(this.lo - this.ptr);
        this.ptr = temp;
        this.capacity = cap;
        this.lo = this.ptr + (long)len;
        this.hi = this.ptr + cap;
    }
}

