/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class Path
extends AbstractCharSink
implements Closeable,
LPSZ {
    public static final ThreadLocal<Path> PATH = new ThreadLocal<Path>(Path::new);
    public static final ThreadLocal<Path> PATH2 = new ThreadLocal<Path>(Path::new);
    public static final Closeable CLEANER = Path::clearThreadLocals;
    private static final int OVERHEAD = 4;
    private long ptr;
    private long wptr;
    private int capacity;
    private int len;

    public Path() {
        this(255);
    }

    public Path(int capacity) {
        this.capacity = capacity;
        this.ptr = this.wptr = Unsafe.malloc(capacity + 1);
    }

    public static void clearThreadLocals() {
        Misc.free(PATH.get());
        PATH.remove();
        Misc.free(PATH2.get());
        PATH2.remove();
    }

    public static Path getThreadLocal(CharSequence root) {
        return ((Path)PATH.get()).of(root);
    }

    public static Path getThreadLocal2(CharSequence root) {
        return ((Path)PATH2.get()).of(root);
    }

    public Path $() {
        if (1L + (this.wptr - this.ptr) >= (long)this.capacity) {
            this.extend((int)(16L + (this.wptr - this.ptr)));
        }
        Unsafe.getUnsafe().putByte(this.wptr++, (byte)0);
        return this;
    }

    public Path slash$() {
        this.ensureSeparator();
        return this.$();
    }

    @Override
    public long address() {
        return this.ptr;
    }

    public Path chop$() {
        this.trimTo(this.length());
        return this;
    }

    @Override
    public void close() {
        if (this.ptr != 0L) {
            Unsafe.free(this.ptr, this.capacity + 1);
            this.ptr = 0L;
        }
    }

    public Path concat(CharSequence str) {
        return this.concat(str, 0, str.length());
    }

    public Path concat(long lpsz) {
        this.ensureSeparator();
        long p = lpsz;
        while (true) {
            int b;
            if (this.len + 4 >= this.capacity) {
                this.extend(this.len * 2 + 4);
            }
            if ((b = Unsafe.getUnsafe().getByte(p++)) == 0) break;
            Unsafe.getUnsafe().putByte(this.wptr, (byte)(b == 47 && Os.type == 3 ? 92 : b));
            ++this.wptr;
            ++this.len;
        }
        return this;
    }

    public Path concat(CharSequence str, int from, int to) {
        this.ensureSeparator();
        this.copy(str, from, to);
        return this;
    }

    @Override
    public void flush() {
        this.$();
    }

    @Override
    public Path put(CharSequence str) {
        int l = str.length();
        if (l + this.len >= this.capacity) {
            this.extend(l + this.len);
        }
        Chars.asciiStrCpy(str, l, this.wptr);
        this.wptr += (long)l;
        this.len += l;
        return this;
    }

    @Override
    public CharSink put(CharSequence cs, int lo, int hi) {
        int l = hi - lo;
        if (l + this.len >= this.capacity) {
            this.extend(l + this.len);
        }
        Chars.asciiStrCpy(cs, lo, l, this.wptr);
        this.wptr += (long)l;
        this.len += l;
        return this;
    }

    @Override
    public Path put(char c) {
        if (1 + this.len >= this.capacity) {
            this.extend(16 + this.len);
        }
        Unsafe.getUnsafe().putByte(this.wptr++, (byte)c);
        ++this.len;
        return this;
    }

    @Override
    public CharSink put(char[] chars, int start, int len) {
        if (len + this.len >= this.capacity) {
            this.extend(len);
        }
        Chars.asciiCopyTo(chars, start, len, this.wptr);
        this.wptr += (long)len;
        return this;
    }

    @Override
    public final int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        return (char)Unsafe.getUnsafe().getByte(this.ptr + (long)index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public Path of(CharSequence str) {
        this.checkClosed();
        if (str == this) {
            this.len = str.length();
            this.wptr = this.ptr + (long)this.len;
            return this;
        }
        this.wptr = this.ptr;
        this.len = 0;
        return this.concat(str);
    }

    private void checkClosed() {
        if (this.ptr == 0L) {
            this.ptr = this.wptr = Unsafe.malloc(this.capacity + 1);
        }
    }

    public Path of(CharSequence str, int from, int to) {
        this.checkClosed();
        this.wptr = this.ptr;
        this.len = 0;
        return this.concat(str, from, to);
    }

    @Override
    public Path put(long value) {
        super.put(value);
        return this;
    }

    @Override
    public Path put(int value) {
        super.put(value);
        return this;
    }

    @Override
    protected void putUtf8Special(char c) {
        if (c == '/' && Os.type == 3) {
            this.put('\\');
        } else {
            this.put(c);
        }
    }

    public Path slash() {
        this.ensureSeparator();
        return this;
    }

    @Override
    @NotNull
    public String toString() {
        return this.ptr == 0L ? "" : AbstractCharSequence.getString(this);
    }

    public Path trimTo(int len) {
        this.len = len;
        this.wptr = this.ptr + (long)len;
        return this;
    }

    private void copy(CharSequence str, int from, int to) {
        this.encodeUtf8(str, from, to);
    }

    protected final void ensureSeparator() {
        if (this.missingTrailingSeparator()) {
            Unsafe.getUnsafe().putByte(this.wptr, (byte)Files.SEPARATOR);
            ++this.wptr;
            ++this.len;
        }
    }

    private void extend(int len) {
        long p = Unsafe.realloc(this.ptr, this.capacity + 1, len + 1);
        long d = this.wptr - this.ptr;
        this.ptr = p;
        this.wptr = p + d;
        this.capacity = len;
    }

    private boolean missingTrailingSeparator() {
        return this.len > 0 && Unsafe.getUnsafe().getByte(this.wptr - 1L) != Files.SEPARATOR;
    }
}

