/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.server;

import java.io.IOException;
import org.seleniumhq.jetty9.server.AbstractNCSARequestLog;
import org.seleniumhq.jetty9.server.RequestLog;
import org.seleniumhq.jetty9.util.annotation.ManagedObject;
import org.seleniumhq.jetty9.util.log.Slf4jLog;

@ManagedObject(value="NCSA standard format request log to slf4j bridge")
public class Slf4jRequestLog
extends AbstractNCSARequestLog
implements RequestLog {
    private Slf4jLog logger;
    private String loggerName = "org.seleniumhq.jetty9.server.RequestLog";

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    protected boolean isEnabled() {
        return this.logger != null;
    }

    @Override
    public void write(String requestEntry) throws IOException {
        this.logger.info(requestEntry, new Object[0]);
    }

    @Override
    protected synchronized void doStart() throws Exception {
        this.logger = new Slf4jLog(this.loggerName);
        super.doStart();
    }
}

