/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml;

import java.io.ByteArrayInputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.exceptions.EntityNotFoundException;
import org.apache.ibatis.features.jpa.generator.EntitySqlDispatcher;
import org.apache.ibatis.session.Configuration;

public class SingletonJpaMapperBuilder
extends XMLMapperBuilder {
    private Configuration configuration;
    private Class clazz;
    private Class entityClass;
    private Class idClass;
    private String resource;
    private String namespace;

    public SingletonJpaMapperBuilder(Configuration configuration, Class<? extends Mapper> clazz) {
        super(new ByteArrayInputStream(SingletonJpaMapperBuilder.getXmlContent(clazz).getBytes()), configuration, SingletonJpaMapperBuilder.getResource(clazz), configuration.getSqlFragments());
        this.resource = SingletonJpaMapperBuilder.getResource(clazz);
        this.clazz = clazz;
        this.namespace = clazz.getName();
        this.configuration = configuration;
        this.findMetaClass(clazz);
    }

    private static String getXmlContent(Class clazz) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE mapper\n        PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\"\n        \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\">\n<mapper namespace=\"" + clazz.getName() + "\"></mapper>";
    }

    private static String getResource(Class clazz) {
        return "JpaMapper:".concat(clazz.getCanonicalName());
    }

    private void findMetaClass(Class mapperClass) {
        Type[] types = mapperClass.getGenericInterfaces();
        if (types != null && types.length > 0) {
            for (Type type : types) {
                Class rawClass;
                if (!(type instanceof ParameterizedType) || !org.apache.ibatis.features.jpa.mapper.Mapper.class.isAssignableFrom(rawClass = (Class)((ParameterizedType)type).getRawType())) continue;
                this.entityClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                this.idClass = (Class)((ParameterizedType)type).getActualTypeArguments()[1];
                EntitySqlDispatcher.getInstance().parseEntity(this.entityClass, this.idClass, this.configuration, this.namespace);
                return;
            }
        }
        throw new EntityNotFoundException("No entity found for mapper : " + mapperClass.getName());
    }

    @Override
    public void parse() {
        try {
            if (!this.configuration.isResourceLoaded(this.resource) && !this.configuration.isJpaMapperLoaded(this.clazz)) {
                super.parse();
            }
        }
        catch (Exception e) {
            throw new BuilderException("Error parsing JpaMapper. Cause: " + e, e);
        }
    }
}

