/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.CacheRefResolver;
import org.apache.ibatis.builder.IncompleteElementException;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.builder.ResultMapResolver;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.builder.xml.XMLStatementBuilder;
import org.apache.ibatis.exceptions.EntityNotFoundException;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.features.jpa.annotation.CustomProvider;
import org.apache.ibatis.features.jpa.builder.SqlContext;
import org.apache.ibatis.features.jpa.generator.EntitySqlDispatcher;
import org.apache.ibatis.features.jpa.generator.SqlGenerator;
import org.apache.ibatis.features.jpa.generator.SqlGeneratorRegistry;
import org.apache.ibatis.features.jpa.mapper.Mapper;
import org.apache.ibatis.features.jpa.meta.Table;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.utils.AnnotationUtils;
import org.apache.ibatis.utils.ReflectionUtils;
import org.apache.ibatis.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public class XMLMapperBuilder
extends BaseBuilder {
    private static final Logger logger = LoggerFactory.getLogger(XMLMapperBuilder.class);
    private final XPathParser parser;
    private final MapperBuilderAssistant builderAssistant;
    private final Map<String, XNode> sqlFragments;
    private final String resource;
    private boolean enabledJpaFeatures = false;
    private Class entityClass;
    private Class idClass;

    @Deprecated
    public XMLMapperBuilder(Reader reader, Configuration configuration, String resource, Map<String, XNode> sqlFragments, String namespace) {
        this(reader, configuration, resource, sqlFragments);
        this.builderAssistant.setCurrentNamespace(namespace);
    }

    @Deprecated
    public XMLMapperBuilder(Reader reader, Configuration configuration, String resource, Map<String, XNode> sqlFragments) {
        this(new XPathParser(reader, true, configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver()), configuration, resource, sqlFragments);
    }

    public XMLMapperBuilder(InputStream inputStream, Configuration configuration, String resource, Map<String, XNode> sqlFragments, String namespace) {
        this(inputStream, configuration, resource, sqlFragments);
        this.builderAssistant.setCurrentNamespace(namespace);
    }

    public XMLMapperBuilder(InputStream inputStream, Configuration configuration, String resource, Map<String, XNode> sqlFragments) {
        this(new XPathParser(inputStream, true, configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver()), configuration, resource, sqlFragments);
    }

    private XMLMapperBuilder(XPathParser parser, Configuration configuration, String resource, Map<String, XNode> sqlFragments) {
        super(configuration);
        this.builderAssistant = new MapperBuilderAssistant(configuration, resource);
        this.parser = parser;
        this.sqlFragments = sqlFragments;
        this.resource = resource;
    }

    public void parse() {
        if (!this.configuration.isResourceLoaded(this.resource)) {
            this.configurationElement(this.parser.evalNode("/mapper"));
            this.configuration.addLoadedResource(this.resource);
            this.bindMapperForNamespace();
        }
        this.parsePendingResultMaps();
        this.parsePendingCacheRefs();
        this.parsePendingStatements();
    }

    public XNode getSqlFragment(String refid) {
        return this.sqlFragments.get(refid);
    }

    private void configurationElement(XNode context) {
        try {
            String namespace = context.getStringAttribute("namespace");
            if (namespace == null || namespace.equals("")) {
                throw new BuilderException("Mapper's namespace cannot be empty");
            }
            Class<?> namespaceClass = Class.forName(namespace);
            if (Mapper.class.isAssignableFrom(namespaceClass)) {
                this.enabledJpaFeatures = true;
                this.findMetaClass(namespaceClass);
                EntitySqlDispatcher.getInstance().parseEntity(this.entityClass, this.idClass, this.configuration, namespace);
            }
            this.builderAssistant.setCurrentNamespace(namespace);
            this.cacheRefElement(context.evalNode("cache-ref"));
            this.cacheElement(context.evalNode("cache"));
            this.parameterMapElement(context.evalNodes("/mapper/parameterMap"));
            this.resultMapElements(context.evalNodes("/mapper/resultMap"));
            this.sqlElement(context.evalNodes("/mapper/sql"));
            if (this.enabledJpaFeatures) {
                this.embeddedEntityResultMap(this.entityClass);
                this.embeddedEntitySql(this.entityClass);
            }
            this.buildStatementFromContext(context.evalNodes("select|insert|update|delete"));
            if (this.enabledJpaFeatures) {
                this.embeddedEntityStatement(this.entityClass, namespace);
                this.checkMethodQueryStatement(namespace);
                this.configuration.addLoadedJpaMapper(namespaceClass);
            }
        }
        catch (Exception e) {
            throw new BuilderException("Error parsing Mapper XML. Cause: " + e, e);
        }
    }

    void checkMethodQueryStatement(String namespace) {
        try {
            Class<?> mapperClass = Class.forName(namespace);
            ReflectionUtils.doWithMethods(mapperClass, method -> {
                String id = namespace + "." + method.getName();
                if (!this.containsStatement(id)) {
                    if (AnnotationUtils.hasOneAnnotation(method, Select.class, Insert.class, Update.class, Delete.class, SelectProvider.class, InsertProvider.class, UpdateProvider.class, DeleteProvider.class)) {
                        return;
                    }
                    SqlContext context = new SqlContext(mapperClass, method);
                    context.parse();
                    String sql = context.getSqlXml();
                    logger.debug("parsing embedded statement, sql: {}, mapper: {}method: {}", new Object[]{sql, mapperClass, method});
                    XPathParser parser = new XPathParser(StringUtils.xmlDeclare(sql), false, this.configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver());
                    this.buildStatementFromContext(parser.evalNodes("select|insert|update|delete"));
                }
            });
        }
        catch (ClassNotFoundException e) {
            throw new BuilderException("Error loading entity sql. Cause: " + e, e);
        }
    }

    private boolean containsStatement(String id) {
        try {
            return this.configuration.getMappedStatement(id) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    void embeddedEntityStatement(Class entity, String namespace) throws ClassNotFoundException {
        Class<?> mapperClass = Class.forName(namespace);
        ReflectionUtils.doWithMethods(mapperClass, method -> {
            if (method.isAnnotationPresent(CustomProvider.class)) {
                try {
                    SqlGenerator generator = SqlGeneratorRegistry.getInstance().parseGenerator(method);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("id", method.getName());
                    String sql = generator.generatorSql(EntitySqlDispatcher.getInstance().getMetaDataParser(entity), map);
                    logger.debug("parsing embedded statement, sql: {}, generator: {}", (Object)sql, (Object)generator);
                    XPathParser parser = new XPathParser(StringUtils.xmlDeclare(sql), false, this.configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver());
                    this.buildStatementFromContext(parser.evalNodes("select|insert|update|delete"));
                }
                catch (InstantiationException e) {
                    throw new BuilderException("Error loading entity sql. Cause: " + e, e);
                }
            }
        });
    }

    private void findMetaClass(Class mapperClass) {
        Type[] types = mapperClass.getGenericInterfaces();
        if (types != null && types.length > 0) {
            for (Type type : types) {
                Class rawClass;
                if (!(type instanceof ParameterizedType) || !Mapper.class.isAssignableFrom(rawClass = (Class)((ParameterizedType)type).getRawType())) continue;
                this.entityClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                this.idClass = (Class)((ParameterizedType)type).getActualTypeArguments()[1];
                return;
            }
        }
        throw new EntityNotFoundException("No entity found for mapper : " + mapperClass.getName());
    }

    private void buildStatementFromContext(List<XNode> list) {
        if (this.configuration.getDatabaseId() != null) {
            this.buildStatementFromContext(list, this.configuration.getDatabaseId());
        }
        this.buildStatementFromContext(list, null);
    }

    private void buildStatementFromContext(List<XNode> list, String requiredDatabaseId) {
        for (XNode context : list) {
            XMLStatementBuilder statementParser = new XMLStatementBuilder(this.configuration, this.builderAssistant, context, requiredDatabaseId);
            try {
                statementParser.parseStatementNode();
            }
            catch (IncompleteElementException e) {
                this.configuration.addIncompleteStatement(statementParser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePendingResultMaps() {
        Collection<ResultMapResolver> incompleteResultMaps;
        Collection<ResultMapResolver> collection = incompleteResultMaps = this.configuration.getIncompleteResultMaps();
        synchronized (collection) {
            Iterator<ResultMapResolver> iter = incompleteResultMaps.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().resolve();
                    iter.remove();
                }
                catch (IncompleteElementException incompleteElementException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePendingCacheRefs() {
        Collection<CacheRefResolver> incompleteCacheRefs;
        Collection<CacheRefResolver> collection = incompleteCacheRefs = this.configuration.getIncompleteCacheRefs();
        synchronized (collection) {
            Iterator<CacheRefResolver> iter = incompleteCacheRefs.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().resolveCacheRef();
                    iter.remove();
                }
                catch (IncompleteElementException incompleteElementException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePendingStatements() {
        Collection<XMLStatementBuilder> incompleteStatements;
        Collection<XMLStatementBuilder> collection = incompleteStatements = this.configuration.getIncompleteStatements();
        synchronized (collection) {
            Iterator<XMLStatementBuilder> iter = incompleteStatements.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().parseStatementNode();
                    iter.remove();
                }
                catch (IncompleteElementException incompleteElementException) {}
            }
        }
    }

    private void cacheRefElement(XNode context) {
        if (context != null) {
            this.configuration.addCacheRef(this.builderAssistant.getCurrentNamespace(), context.getStringAttribute("namespace"));
            CacheRefResolver cacheRefResolver = new CacheRefResolver(this.builderAssistant, context.getStringAttribute("namespace"));
            try {
                cacheRefResolver.resolveCacheRef();
            }
            catch (IncompleteElementException e) {
                this.configuration.addIncompleteCacheRef(cacheRefResolver);
            }
        }
    }

    private void cacheElement(XNode context) throws Exception {
        if (context != null) {
            String type = context.getStringAttribute("type", "PERPETUAL");
            Class typeClass = this.typeAliasRegistry.resolveAlias(type);
            String eviction = context.getStringAttribute("eviction", "LRU");
            Class evictionClass = this.typeAliasRegistry.resolveAlias(eviction);
            Long flushInterval = context.getLongAttribute("flushInterval");
            Integer size = context.getIntAttribute("size");
            boolean readWrite = context.getBooleanAttribute("readOnly", false) == false;
            boolean blocking = context.getBooleanAttribute("blocking", false);
            Properties props = context.getChildrenAsProperties();
            this.builderAssistant.useNewCache(typeClass, evictionClass, flushInterval, size, readWrite, blocking, props);
        }
    }

    private void parameterMapElement(List<XNode> list) throws Exception {
        for (XNode parameterMapNode : list) {
            String id = parameterMapNode.getStringAttribute("id");
            String type = parameterMapNode.getStringAttribute("type");
            Class<?> parameterClass = this.resolveClass(type);
            List<XNode> parameterNodes = parameterMapNode.evalNodes("parameter");
            ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
            for (XNode parameterNode : parameterNodes) {
                String property = parameterNode.getStringAttribute("property");
                String javaType = parameterNode.getStringAttribute("javaType");
                String jdbcType = parameterNode.getStringAttribute("jdbcType");
                String resultMap = parameterNode.getStringAttribute("resultMap");
                String mode = parameterNode.getStringAttribute("mode");
                String typeHandler = parameterNode.getStringAttribute("typeHandler");
                Integer numericScale = parameterNode.getIntAttribute("numericScale");
                ParameterMode modeEnum = this.resolveParameterMode(mode);
                Class<?> javaTypeClass = this.resolveClass(javaType);
                JdbcType jdbcTypeEnum = this.resolveJdbcType(jdbcType);
                Class<?> typeHandlerClass = this.resolveClass(typeHandler);
                ParameterMapping parameterMapping = this.builderAssistant.buildParameterMapping(parameterClass, property, javaTypeClass, jdbcTypeEnum, resultMap, modeEnum, typeHandlerClass, numericScale);
                parameterMappings.add(parameterMapping);
            }
            this.builderAssistant.addParameterMap(id, parameterClass, parameterMappings);
        }
    }

    private void resultMapElements(List<XNode> list) throws Exception {
        for (XNode resultMapNode : list) {
            try {
                this.resultMapElement(resultMapNode);
            }
            catch (IncompleteElementException incompleteElementException) {}
        }
    }

    private ResultMap resultMapElement(XNode resultMapNode) throws Exception {
        return this.resultMapElement(resultMapNode, Collections.emptyList());
    }

    private ResultMap resultMapElement(XNode resultMapNode, List<ResultMapping> additionalResultMappings) throws Exception {
        ErrorContext.instance().activity("processing " + resultMapNode.getValueBasedIdentifier());
        String id = resultMapNode.getStringAttribute("id", resultMapNode.getValueBasedIdentifier());
        String type = resultMapNode.getStringAttribute("type", resultMapNode.getStringAttribute("ofType", resultMapNode.getStringAttribute("resultType", resultMapNode.getStringAttribute("javaType"))));
        String extend = resultMapNode.getStringAttribute("extends");
        Boolean autoMapping = resultMapNode.getBooleanAttribute("autoMapping");
        Class<?> typeClass = this.resolveClass(type);
        Discriminator discriminator = null;
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        resultMappings.addAll(additionalResultMappings);
        List<XNode> resultChildren = resultMapNode.getChildren();
        for (XNode resultChild : resultChildren) {
            if ("constructor".equals(resultChild.getName())) {
                this.processConstructorElement(resultChild, typeClass, resultMappings);
                continue;
            }
            if ("discriminator".equals(resultChild.getName())) {
                discriminator = this.processDiscriminatorElement(resultChild, typeClass, resultMappings);
                continue;
            }
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if ("id".equals(resultChild.getName())) {
                flags.add(ResultFlag.ID);
            }
            resultMappings.add(this.buildResultMappingFromContext(resultChild, typeClass, flags));
        }
        ResultMapResolver resultMapResolver = new ResultMapResolver(this.builderAssistant, id, typeClass, extend, discriminator, resultMappings, autoMapping);
        try {
            return resultMapResolver.resolve();
        }
        catch (IncompleteElementException e) {
            this.configuration.addIncompleteResultMap(resultMapResolver);
            throw e;
        }
    }

    void embeddedEntityResultMap(Class entityClass) throws Exception {
        String resultMap = EntitySqlDispatcher.getInstance().getMetaDataParser(entityClass).getResultMapString();
        XPathParser parser = new XPathParser(StringUtils.xmlDeclare(resultMap), false, this.configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver());
        this.resultMapElements(Collections.singletonList(parser.evalNode("resultMap")));
    }

    private void processConstructorElement(XNode resultChild, Class<?> resultType, List<ResultMapping> resultMappings) throws Exception {
        List<XNode> argChildren = resultChild.getChildren();
        for (XNode argChild : argChildren) {
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            flags.add(ResultFlag.CONSTRUCTOR);
            if ("idArg".equals(argChild.getName())) {
                flags.add(ResultFlag.ID);
            }
            resultMappings.add(this.buildResultMappingFromContext(argChild, resultType, flags));
        }
    }

    private Discriminator processDiscriminatorElement(XNode context, Class<?> resultType, List<ResultMapping> resultMappings) throws Exception {
        String column = context.getStringAttribute("column");
        String javaType = context.getStringAttribute("javaType");
        String jdbcType = context.getStringAttribute("jdbcType");
        String typeHandler = context.getStringAttribute("typeHandler");
        Class<?> javaTypeClass = this.resolveClass(javaType);
        Class<?> typeHandlerClass = this.resolveClass(typeHandler);
        JdbcType jdbcTypeEnum = this.resolveJdbcType(jdbcType);
        HashMap<String, String> discriminatorMap = new HashMap<String, String>();
        for (XNode caseChild : context.getChildren()) {
            String value = caseChild.getStringAttribute("value");
            String resultMap = caseChild.getStringAttribute("resultMap", this.processNestedResultMappings(caseChild, resultMappings));
            discriminatorMap.put(value, resultMap);
        }
        return this.builderAssistant.buildDiscriminator(resultType, column, javaTypeClass, jdbcTypeEnum, typeHandlerClass, discriminatorMap);
    }

    private void sqlElement(List<XNode> list) throws Exception {
        if (this.configuration.getDatabaseId() != null) {
            this.sqlElement(list, this.configuration.getDatabaseId());
        }
        this.sqlElement(list, null);
    }

    private void sqlElement(List<XNode> list, String requiredDatabaseId) throws Exception {
        for (XNode context : list) {
            String databaseId = context.getStringAttribute("databaseId");
            String id = context.getStringAttribute("id");
            if (!this.databaseIdMatchesCurrent(id = this.builderAssistant.applyCurrentNamespace(id, false), databaseId, requiredDatabaseId)) continue;
            this.sqlFragments.put(id, context);
        }
    }

    void embeddedEntitySql(Class entityClass) throws Exception {
        Table table = EntitySqlDispatcher.getInstance().getMetaDataParser(entityClass).getTable();
        ArrayList<XNode> xnodes = new ArrayList<XNode>();
        for (Table.SqlSegment sql : table.getSqlSegments()) {
            logger.debug("parsing embedded sql: {}, entity class: {} ", (Object)sql.toXml(), (Object)entityClass);
            XPathParser parser = new XPathParser(StringUtils.xmlDeclare(sql.toXml()), false, this.configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver());
            xnodes.add(parser.evalNode("sql"));
        }
        this.sqlElement(xnodes);
    }

    private boolean databaseIdMatchesCurrent(String id, String databaseId, String requiredDatabaseId) {
        if (requiredDatabaseId != null) {
            if (!requiredDatabaseId.equals(databaseId)) {
                return false;
            }
        } else {
            XNode context;
            if (databaseId != null) {
                return false;
            }
            if (this.sqlFragments.containsKey(id) && (context = this.sqlFragments.get(id)).getStringAttribute("databaseId") != null) {
                return false;
            }
        }
        return true;
    }

    private ResultMapping buildResultMappingFromContext(XNode context, Class<?> resultType, List<ResultFlag> flags) throws Exception {
        String property = flags.contains((Object)ResultFlag.CONSTRUCTOR) ? context.getStringAttribute("name") : context.getStringAttribute("property");
        String column = context.getStringAttribute("column");
        String javaType = context.getStringAttribute("javaType");
        String jdbcType = context.getStringAttribute("jdbcType");
        String nestedSelect = context.getStringAttribute("select");
        String nestedResultMap = context.getStringAttribute("resultMap", this.processNestedResultMappings(context, Collections.emptyList()));
        String notNullColumn = context.getStringAttribute("notNullColumn");
        String columnPrefix = context.getStringAttribute("columnPrefix");
        String typeHandler = context.getStringAttribute("typeHandler");
        String resultSet = context.getStringAttribute("resultSet");
        String foreignColumn = context.getStringAttribute("foreignColumn");
        boolean lazy = "lazy".equals(context.getStringAttribute("fetchType", this.configuration.isLazyLoadingEnabled() ? "lazy" : "eager"));
        Class<?> javaTypeClass = this.resolveClass(javaType);
        Class<?> typeHandlerClass = this.resolveClass(typeHandler);
        JdbcType jdbcTypeEnum = this.resolveJdbcType(jdbcType);
        return this.builderAssistant.buildResultMapping(resultType, property, column, javaTypeClass, jdbcTypeEnum, nestedSelect, nestedResultMap, notNullColumn, columnPrefix, typeHandlerClass, flags, resultSet, foreignColumn, lazy);
    }

    private String processNestedResultMappings(XNode context, List<ResultMapping> resultMappings) throws Exception {
        if (("association".equals(context.getName()) || "collection".equals(context.getName()) || "case".equals(context.getName())) && context.getStringAttribute("select") == null) {
            ResultMap resultMap = this.resultMapElement(context, resultMappings);
            return resultMap.getId();
        }
        return null;
    }

    void bindMapperForNamespace() {
        String namespace = this.builderAssistant.getCurrentNamespace();
        if (namespace != null) {
            Class<?> boundType = null;
            try {
                boundType = Resources.classForName(namespace);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (boundType != null && !this.configuration.hasMapper(boundType)) {
                this.configuration.addLoadedResource("namespace:" + namespace);
                this.configuration.addMapper(boundType);
            }
        }
    }
}

