/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.features.jpa.builder.SqlBuilderChain;
import org.apache.ibatis.features.jpa.generator.EntitySqlDispatcher;
import org.apache.ibatis.features.jpa.generator.MetaDataParser;
import org.apache.ibatis.features.jpa.generator.impl.AbstractSqlGenerator;
import org.apache.ibatis.features.jpa.mapper.JpaMapper;
import org.apache.ibatis.features.jpa.meta.Table;
import org.apache.ibatis.utils.StringUtils;

public class SqlContext
extends AbstractSqlGenerator {
    private static final String param = "param";
    private static final String[] SEPARATORS = new String[]{"OrderBy", "By", "And", "Or"};
    private Class clazz;
    private Method method;
    private StringBuilder originalSql = new StringBuilder();
    private String limitSegment = "";
    private MetaDataParser metaDataParser;
    private String flag;
    private Table table;
    private int argIndex;
    private Class[] argTypes;
    private Map<Integer, String> argNames;
    private SqlBuilderChain builderChain;
    private List<String> keyWords = new LinkedList<String>();

    public SqlContext(Class clazz, Method method) {
        this.clazz = clazz;
        this.method = method;
        if (!JpaMapper.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Not supported ! ".concat(clazz.getName()));
        }
        this.metaDataParser = EntitySqlDispatcher.getInstance().getMetaDataParserByNamespace(clazz.getName());
        this.table = this.metaDataParser.getTable();
        this.argIndex = 0;
        this.argNames = new HashMap<Integer, String>();
        this.argTypes = method.getParameterTypes();
        this.builderChain = new SqlBuilderChain();
    }

    private void parseMethodName() {
        String name = this.method.getName();
        for (int i = 0; i < name.length(); ++i) {
            for (String s : SEPARATORS) {
                if (i + s.length() >= name.length() || !StringUtils.equalsIgnoreCase(s, name.substring(i, i + s.length()))) continue;
                this.keyWords.add(name.substring(0, i));
                this.keyWords.add(name.substring(i, i + s.length()));
                name = name.substring(i + s.length());
                i = 0;
            }
        }
        this.keyWords.add(name);
    }

    private void parseParams() {
        Class<?>[] argTypes = this.method.getParameterTypes();
        Annotation[][] annotations = this.method.getParameterAnnotations();
        for (int i = 0; i < argTypes.length; ++i) {
            Annotation[] annos = annotations[i];
            Param anno = null;
            for (Annotation a : annos) {
                if (!(a instanceof Param)) continue;
                anno = (Param)a;
                break;
            }
            if (anno != null) {
                this.argNames.put(i, anno.value());
                continue;
            }
            this.argNames.put(i, param + (i + 1));
        }
    }

    public void parse() {
        this.parseMethodName();
        this.parseParams();
        for (String keyWord : this.keyWords) {
            this.builderChain.build(keyWord, this);
            this.builderChain.reset();
        }
    }

    public String getParamName() {
        return this.argNames.get(this.argIndex++);
    }

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public SqlContext append(String sql) {
        this.originalSql.append(" ").append(sql);
        return this;
    }

    public String getOriginalSql() {
        return this.originalSql.toString().concat(this.limitSegment);
    }

    public String getSqlXml() {
        String paramType = null;
        if (this.argTypes.length > 1) {
            paramType = "map";
        } else if (this.argTypes.length == 1) {
            paramType = this.argTypes[0].getName();
        }
        if (StringUtils.equalsIgnoreCase(this.flag, "select")) {
            return this.select(this.method.getName(), paramType, null, null, this.getOriginalSql());
        }
        if (StringUtils.equalsIgnoreCase(this.flag, "delete")) {
            return this.update(this.method.getName(), paramType, this.getOriginalSql());
        }
        throw new BuilderException("Build query from method error ! ".concat(String.valueOf(this.clazz)).concat(".").concat(String.valueOf(this.method)));
    }

    public Table getTable() {
        return this.table;
    }

    public void setLimitSegment(String limitSegment) {
        this.limitSegment = limitSegment;
    }

    public Class[] getArgTypes() {
        return this.argTypes;
    }

    @Override
    public String generatorSql(MetaDataParser dataParser, Map<String, Object> params) {
        return null;
    }
}

