/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.builder.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.features.jpa.builder.MethodSqlBuilder;
import org.apache.ibatis.features.jpa.builder.SqlBuilderChain;
import org.apache.ibatis.features.jpa.builder.SqlContext;
import org.apache.ibatis.features.jpa.generator.MetaDataParser;
import org.apache.ibatis.features.jpa.generator.impl.AbstractSqlGenerator;
import org.apache.ibatis.utils.StringUtils;

public class ComputeSqlBuilder
extends AbstractSqlGenerator
implements MethodSqlBuilder {
    private static final Map<String, String> OPERATORS = new HashMap<String, String>();

    @Override
    public void build(String keyWord, SqlContext sqlContext, SqlBuilderChain builderChain) {
        String operator = OPERATORS.get(keyWord.toLowerCase());
        if (!StringUtils.isEmpty(operator)) {
            StringBuilder sql = new StringBuilder();
            switch (operator) {
                case "between": {
                    sql.append(operator).append(" ").append(this.wrapProperty(sqlContext.getParamName())).append(" and ").append(this.wrapProperty(sqlContext.getParamName()));
                    break;
                }
                case "is null": 
                case "is not null": {
                    sql.append(operator);
                    break;
                }
                case "in": 
                case "not in": {
                    String collection = "list";
                    if (sqlContext.getArgTypes().length > 1) {
                        collection = sqlContext.getParamName();
                    }
                    sql.append(operator).append(" ").append(this.foreach("item", "index", collection, "(", ",", ")", this.wrapProperty("item")));
                    break;
                }
                default: {
                    sql.append(operator).append(" ").append(this.wrapProperty(sqlContext.getParamName()));
                }
            }
            sqlContext.append(sql.toString());
        } else {
            builderChain.build(keyWord, sqlContext);
        }
    }

    @Override
    public String generatorSql(MetaDataParser dataParser, Map<String, Object> params) {
        return null;
    }

    static {
        OPERATORS.put("equal", "=");
        OPERATORS.put("equals", "=");
        OPERATORS.put("is", "=");
        OPERATORS.put("between", "between");
        OPERATORS.put("lessthan", "&lt;");
        OPERATORS.put("lessthanequal", "&lt;=");
        OPERATORS.put("lessthanequals", "&lt;=");
        OPERATORS.put("greaterthan", "&gt;");
        OPERATORS.put("greaterthanequal", "&gt;=");
        OPERATORS.put("greaterthanequals", "&gt;=");
        OPERATORS.put("after", "&gt;");
        OPERATORS.put("before", "&lt;");
        OPERATORS.put("isnull", "is null");
        OPERATORS.put("isnotnull", "is not null");
        OPERATORS.put("notnull", "is not null");
        OPERATORS.put("like", "like");
        OPERATORS.put("notlike", "not like");
        OPERATORS.put("in", "in");
        OPERATORS.put("notin", "not in");
    }
}

