/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.builder.impl;

import org.apache.ibatis.features.jpa.builder.MethodSqlBuilder;
import org.apache.ibatis.features.jpa.builder.SqlBuilderChain;
import org.apache.ibatis.features.jpa.builder.SqlContext;
import org.apache.ibatis.features.jpa.builder.impl.ComputeSqlBuilder;
import org.apache.ibatis.features.jpa.builder.impl.SortDirectionSqlBuilder;
import org.apache.ibatis.features.jpa.meta.Table;
import org.apache.ibatis.utils.StringUtils;

public class PropertySqlBuilder
implements MethodSqlBuilder {
    private ComputeSqlBuilder sqlBuilder = new ComputeSqlBuilder();
    private SortDirectionSqlBuilder sortDirectionSqlBuilder = new SortDirectionSqlBuilder();

    @Override
    public void build(String keyWord, SqlContext sqlContext, SqlBuilderChain builderChain) {
        Table table = sqlContext.getTable();
        this.parseProperty(keyWord, sqlContext, table, "", keyWord, builderChain);
    }

    private void parseProperty(String originalKeyWord, SqlContext sqlContext, Table table, String parsedProperty, String property, SqlBuilderChain builderChain) {
        if (StringUtils.isEmpty(parsedProperty)) {
            property = StringUtils.uncapitalize(property);
        }
        if (table.propertyExists(parsedProperty)) {
            sqlContext.append(table.getColumnByProperty(parsedProperty));
            if (!StringUtils.isEmpty(property)) {
                this.sqlBuilder.build(property, sqlContext, builderChain);
            } else if (!StringUtils.contains(sqlContext.getOriginalSql().toLowerCase(), "order by")) {
                this.sqlBuilder.build("is", sqlContext, builderChain);
            } else {
                this.sortDirectionSqlBuilder.build("asc", sqlContext, builderChain);
            }
        } else {
            if (StringUtils.isEmpty(property)) {
                builderChain.build(originalKeyWord, sqlContext);
                return;
            }
            String nextWord = StringUtils.nextHumpWord(property);
            parsedProperty = parsedProperty + nextWord;
            property = property.substring(nextWord.length());
            this.parseProperty(originalKeyWord, sqlContext, table, parsedProperty, property, builderChain);
        }
    }
}

