/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.ddl;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.features.jpa.ddl.DBType;
import org.apache.ibatis.features.jpa.ddl.DDLGenerator;
import org.apache.ibatis.features.jpa.ddl.DefaultMysqlDDLGenerator;

public class DDLGeneratorFactory {
    private static final DDLGeneratorFactory factory = new DDLGeneratorFactory();
    private static final List<DDLGenerator> GENERATORS = new ArrayList<DDLGenerator>();

    private DDLGeneratorFactory() {
    }

    public static final DDLGeneratorFactory getInstance() {
        return factory;
    }

    public synchronized void register(DDLGenerator ddlGenerator) {
        GENERATORS.add(ddlGenerator);
    }

    public DDLGenerator getDDLGenerator(DBType dbType) {
        for (DDLGenerator ddlGenerator : GENERATORS) {
            if (!ddlGenerator.support(dbType)) continue;
            return ddlGenerator;
        }
        return null;
    }

    static {
        GENERATORS.add(new DefaultMysqlDDLGenerator());
    }
}

