/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.ddl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ibatis.features.jpa.ddl.DBTable;
import org.apache.ibatis.features.jpa.ddl.DBType;
import org.apache.ibatis.features.jpa.ddl.DDLGenerator;
import org.apache.ibatis.features.jpa.ddl.Database;
import org.apache.ibatis.features.jpa.ddl.TableColumn;
import org.apache.ibatis.features.jpa.generator.EntitySqlDispatcher;
import org.apache.ibatis.features.jpa.meta.Column;
import org.apache.ibatis.features.jpa.meta.Table;
import org.apache.ibatis.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMysqlDDLGenerator
implements DDLGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMysqlDDLGenerator.class);

    @Override
    public boolean support(DBType dbType) {
        return dbType == DBType.MYSQL;
    }

    @Override
    public List<String> generateDDL(Connection connection) {
        try {
            ArrayList<String> sql = new ArrayList<String>();
            Database database = this.getDataBase(connection);
            Set<Class> classes = EntitySqlDispatcher.getInstance().getEntities();
            classes.forEach(clazz -> {
                Table table = EntitySqlDispatcher.getInstance().getMetaDataParser((Class)clazz).getTable();
                sql.addAll(this.compareStruct(table, database.getTable(table.getName())));
            });
            return sql;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<String> compareStruct(Table table, DBTable dbtable) {
        logger.info("checking table : {}", (Object)table.getName());
        if (dbtable == null) {
            logger.info("table {} doesn't exists !", (Object)table.getName());
            return Collections.singletonList(this.generateDDL4Table(table));
        }
        HashSet checkedColumns = new HashSet();
        ArrayList alters = new ArrayList();
        table.getColumns(true).forEach(column -> {
            checkedColumns.add(column.getColumn());
            String sql = this.compareColumn((Column)column, dbtable.getColumn(column.getColumn()));
            if (!StringUtils.isEmpty(sql)) {
                alters.add(sql);
            }
        });
        Map<String, Column> columnMap = table.getColumns(true).stream().collect(Collectors.toMap(Column::getColumn, c -> c));
        dbtable.getTableColumns().forEach((k, v) -> {
            if (checkedColumns.contains(k)) {
                return;
            }
            String sql = this.compareColumn((Column)columnMap.get(k), (TableColumn)v);
            if (!StringUtils.isEmpty(sql)) {
                alters.add(sql);
            }
        });
        if (alters.size() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("alter table ").append(table.getName()).append(" \n ");
            for (int i = 0; i < alters.size(); ++i) {
                builder.append((String)alters.get(i));
                if (i != alters.size() - 1) {
                    builder.append(",");
                }
                builder.append(" \n ");
            }
            return Collections.singletonList(builder.toString());
        }
        return Collections.emptyList();
    }

    String compareColumn(Column column, TableColumn tableColumn) {
        StringBuilder builder = new StringBuilder();
        if (tableColumn == null) {
            logger.info("column {} not exists in DB !", (Object)column.getColumn());
            return builder.append(" add column ").append(this.generateDDL4Column(column)).toString();
        }
        if (column == null) {
            logger.info("column {} has been dropped !", (Object)tableColumn.getName());
            builder.append(" drop column ").append(tableColumn.getName()).append(" ");
            return builder.toString();
        }
        if (!StringUtils.isEmpty(column.getColumnDefinition())) {
            return null;
        }
        boolean needUpdate = false;
        if (!StringUtils.equalsIgnoreCase(column.getType(), tableColumn.getType())) {
            logger.info("column type has been changed ! {} -> {}", (Object)tableColumn.getType(), (Object)column.getType());
            needUpdate = true;
        }
        if (!needUpdate && column.isNullable() != tableColumn.isNullable()) {
            logger.info("column nullable has been changed ! {} -> {}", (Object)tableColumn.isNullable(), (Object)column.isNullable());
            needUpdate = true;
        }
        if (!(needUpdate || StringUtils.isEmpty(tableColumn.getDefaultValue()) && StringUtils.isEmpty(column.getDefaultValue()) || StringUtils.equalsIgnoreCase(tableColumn.getDefaultValue(), column.getDefaultValue()))) {
            logger.info("column default value has been changed ! {} -> {}", (Object)tableColumn.getDefaultValue(), (Object)column.getDefaultValue());
            needUpdate = true;
        }
        if (needUpdate) {
            return " change column " + column.getColumn() + " " + this.generateDDL4Column(column) + " ";
        }
        return null;
    }

    public Database getDataBase(Connection conn) throws ClassNotFoundException, SQLException {
        Database database = new Database(conn.getCatalog());
        DatabaseMetaData databaseMetaData = conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(conn.getCatalog(), "%", "%", new String[]{"TABLE"});
        while (resultSet.next()) {
            String tableName = resultSet.getString("TABLE_NAME");
            DBTable table = new DBTable(tableName);
            ResultSet primaryKeyResultSet = databaseMetaData.getPrimaryKeys(conn.getCatalog(), null, tableName);
            HashSet<String> primaryKeys = new HashSet<String>();
            while (primaryKeyResultSet.next()) {
                String primaryKeyColumnName = primaryKeyResultSet.getString("COLUMN_NAME");
                primaryKeys.add(primaryKeyColumnName);
            }
            ResultSet columnResultSet = databaseMetaData.getColumns(conn.getCatalog(), "%", tableName, "%");
            while (columnResultSet.next()) {
                String columnName = columnResultSet.getString("COLUMN_NAME");
                String columnType = columnResultSet.getString("TYPE_NAME");
                int columnSize = 0;
                try {
                    columnSize = columnResultSet.getInt("COLUMN_SIZE");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean nullable = columnResultSet.getInt("NULLABLE") == 1;
                boolean primaryKey = primaryKeys.contains(columnName);
                String defaultValue = columnResultSet.getString("COLUMN_DEF");
                table.addColumn(new TableColumn(columnName, columnType, columnSize, nullable, primaryKey, defaultValue));
            }
            database.addTable(table);
        }
        return database;
    }

    public String generateDDL4Table(Table table) {
        StringBuilder builder = new StringBuilder();
        builder.append("create table ").append(table.getName()).append(" ( \n");
        List<Column> columns = table.getColumns(true);
        for (int i = 0; i < columns.size(); ++i) {
            builder.append(this.generateDDL4Column(columns.get(i)));
            if (i != columns.size() - 1) {
                builder.append(",");
            }
            builder.append(" \n");
        }
        builder.append(") engine=InnoDB default charset utf8 ");
        return builder.toString();
    }

    public String generateDDL4Column(Column column) {
        StringBuilder ddl = new StringBuilder();
        ddl.append(column.getColumn()).append(" ");
        if (!StringUtils.isEmpty(column.getColumnDefinition())) {
            ddl.append(column.getColumnDefinition());
            return ddl.toString();
        }
        ddl.append(column.getType()).append("(");
        if (column.getPrecision() > 0) {
            ddl.append(String.valueOf(column.getPrecision()));
            if (column.getScale() > 0) {
                ddl.append(",").append(String.valueOf(column.getScale()));
            }
        } else if (column.getLength() > 0) {
            ddl.append(String.valueOf(column.getLength()));
        }
        ddl.append(")");
        if (column.isId()) {
            ddl.append(" primary key ");
        } else {
            ddl.append(column.isNullable() ? " null " : " not null ").append(column.isUnique() ? " unique " : "").append(StringUtils.isEmpty(column.getDefaultValue()) ? "" : " default ".concat(column.getDefaultValue())).append(" ");
        }
        return ddl.toString();
    }
}

