/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.domain;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.ibatis.utils.StringUtils;

public enum JdbcTypes {
    STRING("varchar", String.class),
    LONGTEXT("longtext", String.class),
    CHAR("char", Character.TYPE),
    CHAR_OBj("char", Character.class),
    INT("int", Integer.TYPE),
    INTEGER("int", Integer.class),
    SHORT("tinyint", Short.TYPE),
    SHORT_OBJ("tinyint", Short.class),
    BYTE("tinyint", Byte.TYPE),
    BYTE_Obj("tinyint", Byte.class),
    BIGDECIMAL("decimal", BigDecimal.class),
    DATETIME("datetime", Date.class),
    FLOAT("float", Float.TYPE),
    FLOAT_OBJ("float", Float.class),
    BIGINT_OBJ("bigint", Long.class),
    BIGINT("bigint", Long.TYPE),
    DOUBLE("double", Double.TYPE),
    DOUBLE_OBJ("double", Double.class);

    private String jdbcType;
    private Class javaType;

    private JdbcTypes(String jdbcType, Class javaType) {
        this.jdbcType = jdbcType;
        this.javaType = javaType;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public static JdbcTypes jdbcTypeOf(String jdbcType) {
        for (JdbcTypes jdbcTypes : JdbcTypes.values()) {
            if (!StringUtils.equals(jdbcType, jdbcTypes.getJdbcType())) continue;
            return jdbcTypes;
        }
        throw new IllegalArgumentException("No constant match for jdbcType : " + jdbcType);
    }

    public static JdbcTypes javaTypeOf(Class javaType) {
        for (JdbcTypes jdbcTypes : JdbcTypes.values()) {
            if (javaType != jdbcTypes.getJavaType()) continue;
            return jdbcTypes;
        }
        throw new IllegalArgumentException("No constant match for javaType : " + javaType);
    }
}

