/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.generator;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.features.jpa.annotation.CustomProvider;
import org.apache.ibatis.features.jpa.generator.SqlGenerator;
import org.apache.ibatis.utils.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlGeneratorRegistry {
    private static final Logger logger = LoggerFactory.getLogger(SqlGeneratorRegistry.class);
    private static final Map<String, SqlGenerator> GENERATOR_CACHE = new ConcurrentHashMap<String, SqlGenerator>();
    private static final SqlGeneratorRegistry instance = new SqlGeneratorRegistry();

    private SqlGeneratorRegistry() {
    }

    public static SqlGeneratorRegistry getInstance() {
        return instance;
    }

    public SqlGenerator getGenerator(Method method) throws InstantiationException, IllegalAccessException {
        String key = this.generatorCacheKey(method);
        SqlGenerator generator = GENERATOR_CACHE.get(key);
        if (generator == null) {
            return this.parseGenerator(method);
        }
        return generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlGenerator parseGenerator(Method method) throws IllegalAccessException, InstantiationException {
        CustomProvider customProvider = AnnotationUtils.getAnnotation(method, CustomProvider.class);
        String key = this.generatorCacheKey(method);
        if (customProvider == null) {
            throw new IllegalArgumentException(key.concat(" doesn't has a @CustomProvider annotation !"));
        }
        SqlGenerator generator = customProvider.value().newInstance();
        Map<String, SqlGenerator> map = GENERATOR_CACHE;
        synchronized (map) {
            GENERATOR_CACHE.put(key, generator);
        }
        return generator;
    }

    String generatorCacheKey(Method method) {
        return method.getDeclaringClass().getName().concat("#").concat(method.getName());
    }
}

