/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.generator.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ibatis.features.jpa.generator.SqlGenerator;
import org.apache.ibatis.utils.CollectionUtils;
import org.apache.ibatis.utils.StringUtils;

public abstract class AbstractSqlGenerator
implements SqlGenerator {
    public static final String NEW_LINE = " \n ";
    public static final String TAG_DELETE = "delete";
    public static final String TAG_INSERT = "insert";
    public static final String TAG_UPDATE = "update";
    public static final String TAG_SELECT = "select";
    public static final String TAG_WHERE = "where";
    public static final String TAG_IF = "if";
    public static final String TAG_FOREACH = "foreach";
    public static final String TAG_SQL = "sql";
    public static final String TAG_TRIM = "trim";
    public static final String TAG_SET = "set";
    public static final String TAG_CHOOSE = "choose";
    public static final String TAG_WHEN = "when";
    public static final String TAG_OTHERWISE = "otherwise";

    protected String getMethod(Map<String, Object> params) {
        return String.valueOf(params.get("id"));
    }

    protected void trim(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
    }

    protected String wrapProperty(String property) {
        return "#{" + property + "}";
    }

    protected String createSqlStatement(String id, String originalSql) {
        return "<sql id=\"" + id + "\">" + NEW_LINE + originalSql + NEW_LINE + "</sql>";
    }

    protected void appendAttrs(StringBuilder builder, Map<String, String> attrs) {
        if (!CollectionUtils.isEmpty(attrs)) {
            attrs.forEach((k, v) -> {
                if (v != null) {
                    builder.append(" ").append((String)k).append(" = \"").append((String)v).append("\" ");
                }
            });
        }
    }

    protected String createNode(String tag, String id, String rawContent, Map<String, String> attrs) {
        return this.endTag(this.beginTag(tag, id, attrs).append(rawContent), tag).toString();
    }

    protected StringBuilder beginTag(String tag, String id, Map<String, String> attrs) {
        return this.beginTag(new StringBuilder(), tag, id, attrs);
    }

    private StringBuilder beginTag(StringBuilder builder, String tag, String id, Map<String, String> attrs) {
        builder.append("<").append(tag);
        if (!StringUtils.isEmpty(id)) {
            builder.append(" id = \"").append(id).append("\" ");
        }
        this.appendAttrs(builder, attrs);
        builder.append(">").append(NEW_LINE);
        return builder;
    }

    protected StringBuilder endTag(StringBuilder builder, String tag) {
        return builder.append(NEW_LINE).append("</").append(tag).append(">");
    }

    protected String foreach(String item, String index, String collection, String open, String separator, String close, String sql) {
        return this.createNode(TAG_FOREACH, null, sql, new MapBuilder().put("item", item).put("index", index).put("collection", collection).put("open", open).put("separator", separator).put("close", close).build());
    }

    protected String select(String id, String parameterType, String resultType, String resultMap, String sql) {
        MapBuilder builder = new MapBuilder();
        if (!StringUtils.isEmpty(parameterType)) {
            builder.put("parameterType", parameterType);
        }
        if (!StringUtils.isEmpty(resultType)) {
            builder.put("resultType", resultType);
        }
        if (!StringUtils.isEmpty(resultMap)) {
            builder.put("resultMap", resultMap);
        }
        if (StringUtils.isEmpty(resultType) && StringUtils.isEmpty(resultMap)) {
            builder.put("resultMap", "default");
        }
        return this.createNode(TAG_SELECT, id, sql, builder.build());
    }

    protected String insert(String id, String parameterType, String keyProperty, String keyColumn, String useGeneratedKeys, String sql) {
        MapBuilder builder = new MapBuilder();
        if (!StringUtils.isEmpty(parameterType)) {
            builder.put("parameterType", parameterType);
        }
        if (!StringUtils.isEmpty(keyProperty)) {
            builder.put("keyProperty", keyProperty);
        }
        if (!StringUtils.isEmpty(keyColumn)) {
            builder.put("keyColumn", keyColumn);
        }
        if (!StringUtils.isEmpty(useGeneratedKeys)) {
            builder.put("useGeneratedKeys", useGeneratedKeys);
        }
        return this.createNode(TAG_INSERT, id, sql, builder.build());
    }

    protected String ifNotNull(String column, String sql) {
        return this.createNode(TAG_IF, null, sql, new MapBuilder().put("test", column + " != null").build());
    }

    protected String trim(String prefix, String suffix, String suffixOverrides, String sql) {
        return this.createNode(TAG_TRIM, null, sql, new MapBuilder().put("prefix", prefix).put("suffix", suffix).put("suffixOverrides", suffixOverrides).build());
    }

    protected String set(String sql) {
        return this.createNode(TAG_SET, null, sql, null);
    }

    protected String delete(String id, String parameterType, String sql) {
        MapBuilder builder = new MapBuilder();
        if (!StringUtils.isEmpty(parameterType)) {
            builder.put("parameterType", parameterType);
        }
        return this.createNode(TAG_DELETE, id, sql, builder.build());
    }

    protected String update(String id, String parameterType, String sql) {
        MapBuilder builder = new MapBuilder();
        if (!StringUtils.isEmpty(parameterType)) {
            builder.put("parameterType", parameterType);
        }
        return this.createNode(TAG_UPDATE, id, sql, builder.build());
    }

    protected String where(String rawContent) {
        return this.createNode(TAG_WHERE, null, rawContent, null);
    }

    protected String include(String refId) {
        return " <include refid=\"" + refId + "\" />";
    }

    protected static class MapBuilder {
        private Map<String, String> map = new LinkedHashMap<String, String>();

        protected MapBuilder() {
        }

        public MapBuilder put(String k, String v) {
            this.map.put(k, v);
            return this;
        }

        public Map<String, String> build() {
            return this.map;
        }
    }
}

