/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.generator.impl;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.features.jpa.generator.MetaDataParser;
import org.apache.ibatis.features.jpa.generator.impl.AbstractSqlGenerator;
import org.apache.ibatis.features.jpa.meta.Column;
import org.apache.ibatis.features.jpa.meta.Table;

public class SaveAllGeneratorImpl
extends AbstractSqlGenerator {
    boolean useGeneratedKeys() {
        return false;
    }

    protected String values(MetaDataParser dataParser, boolean includingId) {
        Table table = dataParser.getTable();
        StringBuilder builder = new StringBuilder();
        builder.append(" ( ");
        List<Column> columnList = table.getColumns(includingId);
        columnList.forEach(column -> builder.append("#{item.").append(column.getProperty()).append("},"));
        this.trim(builder);
        builder.append(")");
        return builder.toString();
    }

    protected String baseInfo(MetaDataParser dataParser, boolean includingId) {
        Table table = dataParser.getTable();
        StringBuilder builder = new StringBuilder();
        builder.append(" insert into ").append(table.getName()).append(" (");
        List<Column> columnList = table.getColumns(includingId);
        columnList.forEach(column -> builder.append(column.getColumn()).append(","));
        this.trim(builder);
        return builder.append(") values ").toString();
    }

    @Override
    public String generatorSql(MetaDataParser dataParser, Map<String, Object> params) {
        Table table = dataParser.getTable();
        Column id = table.getSingleIdColumn();
        String useGeneratedKeys = null;
        String keyProperty = null;
        String keyColumn = null;
        if (this.useGeneratedKeys()) {
            useGeneratedKeys = "true";
            keyProperty = id.getProperty();
            keyColumn = id.getColumn();
        }
        StringBuilder insert = new StringBuilder();
        insert.append(this.baseInfo(dataParser, !this.useGeneratedKeys())).append(this.foreach("item", "index", "list", null, ",", null, this.values(dataParser, !this.useGeneratedKeys())));
        return this.insert(this.getMethod(params), List.class.getName(), keyProperty, keyColumn, useGeneratedKeys, insert.toString());
    }
}

