/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.meta;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.features.jpa.domain.JdbcTypes;
import org.apache.ibatis.utils.StringUtils;

public abstract class JdbcTypeConverter {
    private static final Map<Class, String> typeMapping;

    public static String toJdbcType(Class javaType) {
        return JdbcTypeConverter.toJdbcType(javaType, 0);
    }

    public static String toJdbcType(Class javaType, int length) {
        if (String.class == javaType) {
            if (length >= 1000) {
                return JdbcTypes.LONGTEXT.getJdbcType();
            }
            return JdbcTypes.STRING.getJdbcType();
        }
        String jdbcType = typeMapping.get(javaType);
        if (StringUtils.isEmpty(jdbcType)) {
            throw new IllegalArgumentException("Unknown jdbc type for java type : " + javaType.getName());
        }
        return jdbcType;
    }

    static {
        HashMap<Class, String> map = new HashMap<Class, String>();
        for (JdbcTypes jdbcTypes : JdbcTypes.values()) {
            map.put(jdbcTypes.getJavaType(), jdbcTypes.getJdbcType());
        }
        typeMapping = Collections.unmodifiableMap(map);
    }
}

