/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.plugins.pagination;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.features.jpa.cache.Cache;
import org.apache.ibatis.features.jpa.cache.SimpleCache;
import org.apache.ibatis.features.jpa.domain.Page;
import org.apache.ibatis.features.jpa.domain.PageImpl;
import org.apache.ibatis.features.jpa.domain.Pageable;
import org.apache.ibatis.features.jpa.plugins.pagination.MSUtils;
import org.apache.ibatis.features.jpa.plugins.pagination.dialect.Dialect;
import org.apache.ibatis.features.jpa.plugins.pagination.dialect.MySqlDialect;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.utils.ReflectionUtils;
import org.apache.ibatis.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class PageInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(PageInterceptor.class);
    private Cache<String, MappedStatement> msCountMap = new SimpleCache<String, MappedStatement>();
    private Cache<String, Class> returnTypeCache = new SimpleCache<String, Class>();
    private Dialect dialect = new MySqlDialect();
    private Field additionalParametersField;
    private String countSuffix = "_COUNT";

    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        Pageable pageable = this.dialect.processPageParam(ms, parameter);
        if (pageable != null) {
            logger.info("statement {} is a page query !", (Object)ms.getId());
            String msId = ms.getId();
            Configuration configuration = ms.getConfiguration();
            Map additionalParameters = (Map)this.additionalParametersField.get(boundSql);
            List resultList = this.getPaginationList(ms, parameter, rowBounds, resultHandler, executor, cacheKey, boundSql, configuration, additionalParameters, pageable);
            if (this.isReturnPage(ms)) {
                Long count = this.getCountNum(ms, parameter, rowBounds, resultHandler, executor, boundSql, msId, configuration);
                return Collections.singletonList(new PageImpl(resultList, pageable, count));
            }
            return resultList;
        }
        if (this.dialect.isSortQuery(ms, parameter, rowBounds)) {
            logger.info("statement {} is sort query !", (Object)ms.getId());
            Configuration configuration = ms.getConfiguration();
            Map additionalParameters = (Map)this.additionalParametersField.get(boundSql);
            List resultList = this.getSortedList(ms, parameter, rowBounds, resultHandler, executor, cacheKey, boundSql, configuration, additionalParameters);
            return resultList;
        }
        return invocation.proceed();
    }

    private boolean isReturnPage(MappedStatement ms) {
        String key = ms.getId();
        Class type = this.returnTypeCache.get(key);
        if (type == null) {
            try {
                Class<?> mapperClass = Class.forName(ms.getNamespace());
                String methodName = ms.getId().substring(ms.getId().lastIndexOf(".") + 1);
                Method method = ReflectionUtils.findMethodByName(mapperClass, methodName);
                if (method != null) {
                    type = method.getReturnType();
                }
            }
            catch (Exception e) {
                logger.error("can not parse return type for method: {}", (Object)ms.getId());
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (type == null) {
                type = List.class;
            }
            this.returnTypeCache.put(key, type);
        }
        return Page.class.isAssignableFrom(type);
    }

    private List getSortedList(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, Executor executor, CacheKey cacheKey, BoundSql boundSql, Configuration configuration, Map<String, Object> additionalParameters) throws SQLException {
        String sortedSql = this.dialect.getSortSql(ms, boundSql, parameter, rowBounds, cacheKey);
        logger.info("sorted sql is : {}, for statement: {}", (Object)sortedSql, (Object)ms.getId());
        BoundSql pageBoundSql = new BoundSql(configuration, sortedSql, boundSql.getParameterMappings(), parameter);
        for (String key : additionalParameters.keySet()) {
            pageBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
        }
        List resultList = executor.query(ms, parameter, RowBounds.DEFAULT, resultHandler, cacheKey, pageBoundSql);
        return resultList;
    }

    private List getPaginationList(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, Executor executor, CacheKey cacheKey, BoundSql boundSql, Configuration configuration, Map<String, Object> additionalParameters, Pageable pageable) throws SQLException {
        CacheKey pageKey = cacheKey;
        String pageSql = this.dialect.getPageSql(ms, boundSql, pageable, rowBounds, pageKey);
        logger.info("page sql for ms {} is : {}", (Object)ms.getId(), (Object)pageSql);
        BoundSql pageBoundSql = new BoundSql(configuration, pageSql, boundSql.getParameterMappings(), parameter);
        for (String key : additionalParameters.keySet()) {
            pageBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
        }
        List resultList = executor.query(ms, parameter, RowBounds.DEFAULT, resultHandler, pageKey, pageBoundSql);
        return resultList;
    }

    private Long getCountNum(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, Executor executor, BoundSql boundSql, String msId, Configuration configuration) throws IllegalAccessException, SQLException {
        Long count;
        String countMsId = msId + this.countSuffix;
        MappedStatement countMs = this.getExistedMappedStatement(configuration, countMsId);
        if (countMs != null) {
            count = this.executeManualCount(executor, countMs, parameter, boundSql, resultHandler);
        } else {
            countMs = this.msCountMap.get(countMsId);
            if (countMs == null) {
                countMs = MSUtils.newCountMappedStatement(ms, countMsId);
                this.msCountMap.put(countMsId, countMs);
            }
            count = this.executeAutoCount(executor, countMs, parameter, boundSql, rowBounds, resultHandler);
        }
        return count;
    }

    private Long executeManualCount(Executor executor, MappedStatement countMs, Object parameter, BoundSql boundSql, ResultHandler resultHandler) throws IllegalAccessException, SQLException {
        CacheKey countKey = executor.createCacheKey(countMs, parameter, RowBounds.DEFAULT, boundSql);
        BoundSql countBoundSql = countMs.getBoundSql(parameter);
        List countResultList = executor.query(countMs, parameter, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql);
        Long count = ((Number)countResultList.get(0)).longValue();
        return count;
    }

    private Long executeAutoCount(Executor executor, MappedStatement countMs, Object parameter, BoundSql boundSql, RowBounds rowBounds, ResultHandler resultHandler) throws IllegalAccessException, SQLException {
        Map additionalParameters = (Map)this.additionalParametersField.get(boundSql);
        CacheKey countKey = executor.createCacheKey(countMs, parameter, RowBounds.DEFAULT, boundSql);
        String countSql = this.dialect.getCountSql(countMs, boundSql, parameter, rowBounds, countKey);
        BoundSql countBoundSql = new BoundSql(countMs.getConfiguration(), countSql, boundSql.getParameterMappings(), parameter);
        for (String key : additionalParameters.keySet()) {
            countBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
        }
        List countResultList = executor.query(countMs, parameter, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql);
        Long count = (Long)countResultList.get(0);
        return count;
    }

    private MappedStatement getExistedMappedStatement(Configuration configuration, String msId) {
        MappedStatement mappedStatement = null;
        try {
            mappedStatement = configuration.getMappedStatement(msId, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mappedStatement;
    }

    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {
        String dialectClass = properties.getProperty("dialect");
        if (StringUtils.isEmpty(dialectClass)) {
            this.dialect = new MySqlDialect();
        } else {
            try {
                this.dialect = (Dialect)Class.forName(dialectClass).newInstance();
            }
            catch (Exception e) {
                logger.error("can not create instance of {}", (Object)dialectClass);
                throw new RuntimeException(e);
            }
        }
        try {
            this.additionalParametersField = BoundSql.class.getDeclaredField("additionalParameters");
            this.additionalParametersField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Error found field additionalParameters of BoundSql");
        }
    }
}

