/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.plugins.pagination.dialect;

import java.util.Map;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.features.jpa.cache.Cache;
import org.apache.ibatis.features.jpa.cache.SimpleCache;
import org.apache.ibatis.features.jpa.domain.Pageable;
import org.apache.ibatis.features.jpa.domain.Sort;
import org.apache.ibatis.features.jpa.generator.EntitySqlDispatcher;
import org.apache.ibatis.features.jpa.generator.MetaDataParser;
import org.apache.ibatis.features.jpa.plugins.pagination.dialect.CountSqlParser;
import org.apache.ibatis.features.jpa.plugins.pagination.dialect.Dialect;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;

public abstract class AbstractDialect
implements Dialect {
    private static final String DEFAULT_INDEX = "";
    private static final Cache<String, String> MS_PAGE_CACHE = new SimpleCache<String, String>();
    private static final Cache<String, String> MS_SORT_CACHE = new SimpleCache<String, String>();
    protected CountSqlParser countSqlParser = new CountSqlParser();

    @Override
    public boolean isPageQuery(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return this.extractPageParam(ms, parameterObject) != null;
    }

    @Override
    public boolean isSortQuery(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return this.extractSortParam(ms, parameterObject) != null;
    }

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        return this.countSqlParser.getSmartCountSql(boundSql.getSql());
    }

    @Override
    public String getPageSql(MappedStatement ms, BoundSql boundSql, Pageable pageable, RowBounds rowBounds, CacheKey pageKey) {
        String sql = boundSql.getSql();
        if (pageable == null) {
            return sql;
        }
        return this.getPageSql(this.getSortSql(ms, sql, pageable.getSort()), pageable, pageKey);
    }

    protected abstract String getPageSql(String var1, Pageable var2, CacheKey var3);

    @Override
    public String getSortSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey pageKey) {
        String sql = boundSql.getSql();
        Sort sort = this.extractSortParam(ms, parameterObject);
        return this.getSortSql(ms, sql, sort);
    }

    protected String getSortSql(MappedStatement ms, String sql, Sort sort) {
        if (sql.toLowerCase().contains("order by")) {
            return sql;
        }
        MetaDataParser dataParser = EntitySqlDispatcher.getInstance().getMetaDataParserByNamespace(ms.getNamespace());
        if (sort != null) {
            String sortSql = sort.toSql(dataParser.getTable());
            return sql.concat(" order by ").concat(sortSql);
        }
        return sql;
    }

    @Override
    public Pageable processPageParam(MappedStatement ms, Object paramObject) {
        return this.extractPageParam(ms, paramObject);
    }

    Sort extractSortParam(MappedStatement ms, Object parameterObject) {
        String index = MS_SORT_CACHE.get(ms.getId());
        if (index == null) {
            if (parameterObject instanceof Map) {
                for (Map.Entry entry : ((Map)parameterObject).entrySet()) {
                    Object value = entry.getValue();
                    if (value instanceof Sort) {
                        MS_SORT_CACHE.put(ms.getId(), (String)entry.getKey());
                        return (Sort)value;
                    }
                    if (!(value instanceof Pageable)) continue;
                    MS_SORT_CACHE.put(ms.getId(), (String)entry.getKey());
                    return ((Pageable)value).getSort();
                }
            }
            MS_SORT_CACHE.put(ms.getId(), DEFAULT_INDEX);
        } else if (!DEFAULT_INDEX.equals(index)) {
            return (Sort)((Map)parameterObject).get(index);
        }
        if (parameterObject instanceof Sort) {
            return (Sort)parameterObject;
        }
        if (parameterObject instanceof Pageable) {
            return ((Pageable)parameterObject).getSort();
        }
        return null;
    }

    Pageable extractPageParam(MappedStatement ms, Object parameterObject) {
        String index = MS_PAGE_CACHE.get(ms.getId());
        if (index == null) {
            if (parameterObject instanceof Map) {
                for (Map.Entry entry : ((Map)parameterObject).entrySet()) {
                    Object value = entry.getValue();
                    if (!(value instanceof Pageable)) continue;
                    MS_PAGE_CACHE.put(ms.getId(), (String)entry.getKey());
                    return (Pageable)value;
                }
            }
            MS_PAGE_CACHE.put(ms.getId(), DEFAULT_INDEX);
        } else if (!DEFAULT_INDEX.equals(index)) {
            return (Pageable)((Map)parameterObject).get(index);
        }
        if (parameterObject instanceof Pageable) {
            return (Pageable)parameterObject;
        }
        return null;
    }
}

