/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.utils;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;

public abstract class AnnotationUtils {
    public static <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> annotationType) {
        return element.getAnnotation(annotationType);
    }

    public static <T extends Annotation> boolean hasAnnotation(AnnotatedElement element, Class<T> annotationType) {
        return element.isAnnotationPresent(annotationType);
    }

    public static boolean hasOneAnnotation(AnnotatedElement element, Class ... annotationTypes) {
        for (Class cla : annotationTypes) {
            if (!element.isAnnotationPresent(cla)) continue;
            return true;
        }
        return false;
    }

    public static Annotation[] getAnnotations(AnnotatedElement element) {
        return element.getAnnotations();
    }

    public static <T extends Annotation> T getAnnotationRecursive(AnnotatedElement element, Class<T> annotationType) {
        T anno = AnnotationUtils.getAnnotation(element, annotationType);
        if (anno == null) {
            Annotation[] annotations = AnnotationUtils.getAnnotations(element);
            if (annotations == null || annotations.length == 0) {
                return null;
            }
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> type = annotation.annotationType();
                if (type == Retention.class || type == Target.class || type == Documented.class || (anno = AnnotationUtils.getAnnotationRecursive(type, annotationType)) == null) continue;
                return anno;
            }
        }
        return anno;
    }
}

