/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageScan {
    public static List<String> getClassNames(String packageName, boolean recursive) {
        LinkedList<String> list = new LinkedList<String>();
        String packageDirName = packageName.replace('.', '/');
        Enumeration<URL> urls = null;
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    PackageScan.findClassesByFile(packageName, filePath, recursive, list);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                PackageScan.findClassesByJar(url, packageName, packageDirName, list);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void findClassesByJar(URL url, String packageName, String packageDirName, List<String> classNames) throws IOException {
        JarFile jar = null;
        jar = ((JarURLConnection)url.openConnection()).getJarFile();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (!name.startsWith(packageDirName)) continue;
            int idx = name.lastIndexOf(47);
            if (idx != -1) {
                packageName = name.substring(0, idx).replace('/', '.');
            }
            if (idx == -1 || !name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(packageName.length() + 1, name.length() - 6);
            classNames.add(packageName + '.' + className);
        }
    }

    public static void findClassesByFile(String packageName, String packagePath, final boolean recursive, List<String> classNames) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                PackageScan.findClassesByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classNames);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            classNames.add(packageName + '.' + className);
        }
    }

    public static List<String> getClassName(String packageName) {
        ArrayList<String> classNames = new ArrayList<String>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            File[] files;
            String resourceName = packageName.replaceAll("\\.", "/");
            URL url = loader.getResource(resourceName);
            File urlFile = new File(url.toURI());
            for (File f : files = urlFile.listFiles()) {
                PackageScan.getClassName(packageName, f, classNames);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return classNames;
    }

    private static void getClassName(String packageName, File packageFile, List<String> list) {
        if (packageFile.isFile()) {
            list.add(packageName + "." + packageFile.getName().replace(".class", ""));
        } else {
            File[] files = packageFile.listFiles();
            String tmPackageName = packageName + "." + packageFile.getName();
            for (File f : files) {
                PackageScan.getClassName(tmPackageName, f, list);
            }
        }
    }
}

