/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonarsource.scanner.maven.bootstrap.MavenCompilerResolver;
import org.sonarsource.scanner.maven.bootstrap.MavenUtils;
import org.sonarsource.scanner.maven.bootstrap.ToolchainResolver;

public class Maven3ToolchainResolver
implements ToolchainResolver {
    private final MavenSession session;
    private final Log log;
    private final ToolchainManager toolchainManager;

    public Maven3ToolchainResolver(MavenSession session, Log log, ToolchainManager toolchainManager) {
        this.session = session;
        this.log = log;
        this.toolchainManager = toolchainManager;
    }

    @Override
    public Optional<Path> getJdkHomeFromToolchains(MojoExecution compilerExecution) {
        String javacToUse;
        List<Toolchain> tcs;
        Toolchain tc = null;
        Optional<Map<String, String>> jdkToolchain = this.getMapConfiguration(compilerExecution, "jdkToolchain");
        if (jdkToolchain.isPresent() && !jdkToolchain.get().isEmpty() && !(tcs = this.collectMatchingToolchains(jdkToolchain.get())).isEmpty()) {
            tc = tcs.get(0);
        }
        if (tc == null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        if (tc != null && StringUtils.isNotEmpty((CharSequence)(javacToUse = tc.findTool("javac")))) {
            return MavenCompilerResolver.toJdkHomeFromJavacExec(javacToUse);
        }
        return Optional.empty();
    }

    private List<Toolchain> collectMatchingToolchains(Map<String, String> jdkToolchain) {
        try {
            Method getToolchainsMethod = this.toolchainManager.getClass().getMethod("getToolchains", MavenSession.class, String.class, Map.class);
            return (List)getToolchainsMethod.invoke((Object)this.toolchainManager, this.session, "jdk", jdkToolchain);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return Collections.emptyList();
        }
    }

    private Optional<Map<String, String>> getMapConfiguration(MojoExecution exec, String parameterName) {
        Xpp3Dom configuration = exec.getConfiguration();
        XmlPlexusConfiguration pomConfiguration = new XmlPlexusConfiguration(configuration);
        PlexusConfiguration config = pomConfiguration.getChild(parameterName, false);
        if (config == null) {
            return Optional.empty();
        }
        return Optional.of(Stream.of(config.getChildren()).collect(Collectors.toMap(PlexusConfiguration::getName, c -> MavenUtils.convertString(this.session, this.log, exec, config.getChild(c.getName(), false)))));
    }
}

