/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.qianfan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springaicommunity.qianfan.api.QianFanApi;
import org.springframework.ai.chat.prompt.ChatOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class QianFanChatOptions
implements ChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="max_output_tokens")
    private Integer maxTokens;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="response_format")
    private QianFanApi.ChatCompletionRequest.ResponseFormat responseFormat;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;

    public static Builder builder() {
        return new Builder();
    }

    public static QianFanChatOptions fromOptions(QianFanChatOptions fromOptions) {
        return QianFanChatOptions.builder().model(fromOptions.getModel()).frequencyPenalty(fromOptions.getFrequencyPenalty()).maxTokens(fromOptions.getMaxTokens()).presencePenalty(fromOptions.getPresencePenalty()).responseFormat(fromOptions.getResponseFormat()).stop(fromOptions.getStop()).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).build();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public QianFanApi.ChatCompletionRequest.ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(QianFanApi.ChatCompletionRequest.ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.frequencyPenalty == null ? 0 : this.frequencyPenalty.hashCode());
        result = 31 * result + (this.maxTokens == null ? 0 : this.maxTokens.hashCode());
        result = 31 * result + (this.presencePenalty == null ? 0 : this.presencePenalty.hashCode());
        result = 31 * result + (this.responseFormat == null ? 0 : this.responseFormat.hashCode());
        result = 31 * result + (this.stop == null ? 0 : this.stop.hashCode());
        result = 31 * result + (this.temperature == null ? 0 : this.temperature.hashCode());
        result = 31 * result + (this.topP == null ? 0 : this.topP.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QianFanChatOptions other = (QianFanChatOptions)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.frequencyPenalty == null ? other.frequencyPenalty != null : !this.frequencyPenalty.equals(other.frequencyPenalty)) {
            return false;
        }
        if (this.maxTokens == null ? other.maxTokens != null : !this.maxTokens.equals(other.maxTokens)) {
            return false;
        }
        if (this.presencePenalty == null ? other.presencePenalty != null : !this.presencePenalty.equals(other.presencePenalty)) {
            return false;
        }
        if (this.responseFormat == null ? other.responseFormat != null : !this.responseFormat.equals(other.responseFormat)) {
            return false;
        }
        if (this.stop == null ? other.stop != null : !this.stop.equals(other.stop)) {
            return false;
        }
        if (this.temperature == null ? other.temperature != null : !this.temperature.equals(other.temperature)) {
            return false;
        }
        return !(this.topP == null ? other.topP != null : !this.topP.equals(other.topP));
    }

    public QianFanChatOptions copy() {
        return QianFanChatOptions.fromOptions(this);
    }

    public static class Builder {
        protected QianFanChatOptions options;

        public Builder() {
            this.options = new QianFanChatOptions();
        }

        public Builder(QianFanChatOptions options) {
            this.options = options;
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder responseFormat(QianFanApi.ChatCompletionRequest.ResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public QianFanChatOptions build() {
            return this.options;
        }
    }
}

