/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.config;

import com.alibaba.cloud.sentinel.SentinelProperties;
import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.SentinelWebInterceptor;
import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.callback.DefaultBlockExceptionHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.callback.RequestOriginParser;
import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.config.SentinelWebMvcConfig;
import com.alibaba.csp.sentinel.adapter.web.common.UrlCleaner;
import java.util.Optional;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class BladeSentinelFilterConfiguration {
    @Bean
    public SentinelWebInterceptor sentinelWebInterceptor(SentinelWebMvcConfig sentinelWebMvcConfig) {
        return new SentinelWebInterceptor(sentinelWebMvcConfig);
    }

    @Bean
    public SentinelWebMvcConfig sentinelWebMvcConfig(SentinelProperties properties, Optional<UrlCleaner> urlCleanerOptional, Optional<BlockExceptionHandler> blockExceptionHandlerOptional, Optional<RequestOriginParser> requestOriginParserOptional) {
        SentinelWebMvcConfig sentinelWebMvcConfig = new SentinelWebMvcConfig();
        sentinelWebMvcConfig.setHttpMethodSpecify(properties.getHttpMethodSpecify().booleanValue());
        sentinelWebMvcConfig.setWebContextUnify(properties.getWebContextUnify().booleanValue());
        if (blockExceptionHandlerOptional.isPresent()) {
            blockExceptionHandlerOptional.ifPresent(arg_0 -> ((SentinelWebMvcConfig)sentinelWebMvcConfig).setBlockExceptionHandler(arg_0));
        } else if (StringUtils.hasText((String)properties.getBlockPage())) {
            sentinelWebMvcConfig.setBlockExceptionHandler((request, response, s, e) -> response.sendRedirect(properties.getBlockPage()));
        } else {
            sentinelWebMvcConfig.setBlockExceptionHandler((BlockExceptionHandler)new DefaultBlockExceptionHandler());
        }
        urlCleanerOptional.ifPresent(arg_0 -> ((SentinelWebMvcConfig)sentinelWebMvcConfig).setUrlCleaner(arg_0));
        requestOriginParserOptional.ifPresent(arg_0 -> ((SentinelWebMvcConfig)sentinelWebMvcConfig).setOriginParser(arg_0));
        return sentinelWebMvcConfig;
    }

    @Generated
    public BladeSentinelFilterConfiguration() {
    }
}

