/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.feign;

import com.fasterxml.jackson.databind.JsonNode;
import feign.FeignException;
import java.lang.reflect.Method;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.tool.api.IResultCode;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.api.ResultCode;
import org.springblade.core.tool.jackson.JsonUtil;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.lang.Nullable;

public class BladeFeignFallback<T>
implements MethodInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BladeFeignFallback.class);
    private final Class<T> targetType;
    private final String targetName;
    private final Throwable cause;
    private static final String CODE = "code";

    @Nullable
    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        String errorMessage = this.cause.getMessage();
        log.error("BladeFeignFallback:[{}.{}] serviceId:[{}] message:[{}]", new Object[]{this.targetType.getName(), method.getName(), this.targetName, errorMessage});
        Class<?> returnType = method.getReturnType();
        if (R.class != returnType) {
            return null;
        }
        if (!(this.cause instanceof FeignException)) {
            return R.fail((IResultCode)ResultCode.INTERNAL_SERVER_ERROR, (String)errorMessage);
        }
        FeignException exception = (FeignException)this.cause;
        byte[] content = exception.content();
        if (ObjectUtil.isEmpty((Object)content)) {
            return R.fail((IResultCode)ResultCode.INTERNAL_SERVER_ERROR, (String)errorMessage);
        }
        JsonNode resultNode = JsonUtil.readTree((byte[])content);
        if (resultNode.has(CODE)) {
            return JsonUtil.getInstance().convertValue((Object)resultNode, R.class);
        }
        return R.fail((String)resultNode.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BladeFeignFallback that = (BladeFeignFallback)o;
        return this.targetType.equals(that.targetType);
    }

    public int hashCode() {
        return Objects.hash(this.targetType);
    }

    @Generated
    public BladeFeignFallback(Class<T> targetType, String targetName, Throwable cause) {
        this.targetType = targetType;
        this.targetName = targetName;
        this.cause = cause;
    }
}

