/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.request;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.springblade.core.tool.request.BladeHttpServletRequestWrapper;
import org.springblade.core.tool.request.RequestProperties;
import org.springblade.core.tool.request.XssHttpServletRequestWrapper;
import org.springblade.core.tool.request.XssProperties;
import org.springblade.core.tool.utils.WebUtil;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PatternMatchUtils;

public class BladeRequestFilter
implements Filter {
    private final RequestProperties requestProperties;
    private final XssProperties xssProperties;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private final List<String> defaultBlockUrl = List.of("/**/actuator/**", "/health/**");
    private final List<String> defaultWhiteList = List.of("127.0.0.1", "172.30.*.*", "192.168.*.*", "10.*.*.*", "0:0:0:0:0:0:0:1");
    private static final String DEFAULT_MESSAGE = "\u5f53\u524d\u8bf7\u6c42\u88ab\u62d2\u7edd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01";

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String ip;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getServletPath();
        if (this.requestProperties.getEnabled().booleanValue() && this.isRequestBlock(path, ip = WebUtil.getIP(httpRequest))) {
            throw new ServletException(DEFAULT_MESSAGE);
        }
        if (!this.requestProperties.getEnabled().booleanValue() || this.isRequestSkip(path)) {
            chain.doFilter(request, response);
        } else if (!this.xssProperties.getEnabled().booleanValue() || this.isXssSkip(path)) {
            BladeHttpServletRequestWrapper bladeRequest = new BladeHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)bladeRequest, response);
        } else {
            XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)xssRequest, response);
        }
    }

    private boolean isWhiteList(String ip) {
        List<String> whiteList = this.requestProperties.getWhiteList();
        String[] defaultWhiteIps = this.defaultWhiteList.toArray(new String[0]);
        String[] whiteIps = whiteList.toArray(new String[0]);
        return PatternMatchUtils.simpleMatch((String[])defaultWhiteIps, (String)ip) || PatternMatchUtils.simpleMatch((String[])whiteIps, (String)ip);
    }

    private boolean isBlackList(String ip) {
        List<String> blackList = this.requestProperties.getBlackList();
        String[] blackIps = blackList.toArray(new String[0]);
        return PatternMatchUtils.simpleMatch((String[])blackIps, (String)ip);
    }

    private boolean isRequestBlock(String path) {
        List<String> blockUrl = this.requestProperties.getBlockUrl();
        return this.defaultBlockUrl.stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, path)) || blockUrl.stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, path));
    }

    private boolean isRequestBlock(String path, String ip) {
        return this.isRequestBlock(path) && !this.isWhiteList(ip) || this.isBlackList(ip);
    }

    private boolean isRequestSkip(String path) {
        return this.requestProperties.getSkipUrl().stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, path));
    }

    private boolean isXssSkip(String path) {
        return this.xssProperties.getSkipUrl().stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, path));
    }

    public void destroy() {
    }

    @Generated
    public BladeRequestFilter(RequestProperties requestProperties, XssProperties xssProperties) {
        this.requestProperties = requestProperties;
        this.xssProperties = xssProperties;
    }
}

