/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springblade.core.tool.utils.Charsets;
import org.springblade.core.tool.utils.Exceptions;
import org.springblade.core.tool.utils.IoUtil;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.multipart.MultipartFile;

public final class FileUtil
extends FileCopyUtils {
    public static List<File> list(String path) {
        File file = new File(path);
        return FileUtil.list(file, (FileFilter)TrueFilter.TRUE);
    }

    public static List<File> list(String path, String fileNamePattern) {
        File file = new File(path);
        return FileUtil.list(file, (File pathname) -> {
            String fileName = pathname.getName();
            return PatternMatchUtils.simpleMatch((String)fileNamePattern, (String)fileName);
        });
    }

    public static List<File> list(String path, FileFilter filter) {
        File file = new File(path);
        return FileUtil.list(file, filter);
    }

    public static List<File> list(File file) {
        ArrayList<File> fileList = new ArrayList<File>();
        return FileUtil.list(file, fileList, TrueFilter.TRUE);
    }

    public static List<File> list(File file, String fileNamePattern) {
        ArrayList<File> fileList = new ArrayList<File>();
        return FileUtil.list(file, fileList, pathname -> {
            String fileName = pathname.getName();
            return PatternMatchUtils.simpleMatch((String)fileNamePattern, (String)fileName);
        });
    }

    public static List<File> list(File file, FileFilter filter) {
        ArrayList<File> fileList = new ArrayList<File>();
        return FileUtil.list(file, fileList, filter);
    }

    private static List<File> list(File file, List<File> fileList, FileFilter filter) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    FileUtil.list(f, fileList, filter);
                }
            }
        } else {
            boolean accept = filter.accept(file);
            if (file.exists() && accept) {
                fileList.add(file);
            }
        }
        return fileList;
    }

    public static String getFileExtension(String fullName) {
        Assert.notNull((Object)fullName, (String)"file fullName is null.");
        String fileName = new File(fullName).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    public static String getNameWithoutExtension(String file) {
        Assert.notNull((Object)file, (String)"file is null.");
        String fileName = new File(file).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    public static String getTempDirPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getTempDir() {
        return new File(FileUtil.getTempDirPath());
    }

    public static String readToString(File file) {
        return FileUtil.readToString(file, Charsets.UTF_8);
    }

    public static String readToString(File file, Charset encoding) {
        String string;
        block8: {
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                string = IoUtil.toString(in, encoding);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Exceptions.unchecked(e);
                }
            }
            in.close();
        }
        return string;
    }

    public static byte[] readToByteArray(File file) {
        byte[] byArray;
        block8: {
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                byArray = IoUtil.toByteArray(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Exceptions.unchecked(e);
                }
            }
            in.close();
        }
        return byArray;
    }

    public static void writeToFile(File file, String data) {
        FileUtil.writeToFile(file, data, Charsets.UTF_8, false);
    }

    public static void writeToFile(File file, String data, boolean append) {
        FileUtil.writeToFile(file, data, Charsets.UTF_8, append);
    }

    public static void writeToFile(File file, String data, Charset encoding) {
        FileUtil.writeToFile(file, data, encoding, false);
    }

    public static void writeToFile(File file, String data, Charset encoding, boolean append) {
        try (FileOutputStream out = new FileOutputStream(file, append);){
            IoUtil.write(data, out, encoding);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static void toFile(MultipartFile multipartFile, File file) {
        try {
            FileUtil.toFile(multipartFile.getInputStream(), file);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static void toFile(InputStream in, File file) {
        try (FileOutputStream out = new FileOutputStream(file);){
            FileUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static void moveFile(File srcFile, File destFile) throws IOException {
        Assert.notNull((Object)srcFile, (String)"Source must not be null");
        Assert.notNull((Object)destFile, (String)"Destination must not be null");
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
        }
        if (srcFile.isDirectory()) {
            throw new IOException("Source '" + srcFile + "' is a directory");
        }
        if (destFile.exists()) {
            throw new IOException("Destination '" + destFile + "' already exists");
        }
        if (destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' is a directory");
        }
        boolean rename = srcFile.renameTo(destFile);
        if (!rename) {
            FileUtil.copy((File)srcFile, (File)destFile);
            if (!srcFile.delete()) {
                FileUtil.deleteQuietly(destFile);
                throw new IOException("Failed to delete original file '" + srcFile + "' after copy to '" + destFile + "'");
            }
        }
    }

    public static boolean deleteQuietly(@Nullable File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileSystemUtils.deleteRecursively((File)file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Generated
    private FileUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class TrueFilter
    implements FileFilter,
    Serializable {
        private static final long serialVersionUID = -6420452043795072619L;
        public static final TrueFilter TRUE = new TrueFilter();

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    }
}

