/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.log.error;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.springblade.core.tool.jackson.JsonUtil;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class BladeErrorController
extends BasicErrorController {
    public BladeErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties) {
        super(errorAttributes, errorProperties);
    }

    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        boolean includeStackTrace = this.isIncludeStackTrace(request, MediaType.ALL);
        Map body = this.getErrorAttributes(request, includeStackTrace ? ErrorAttributeOptions.of((ErrorAttributeOptions.Include[])new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.STACK_TRACE}) : ErrorAttributeOptions.defaults());
        HttpStatus status = this.getStatus(request);
        response.setStatus(status.value());
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        view.setObjectMapper(JsonUtil.getInstance());
        view.setContentType("application/json");
        return new ModelAndView((View)view, body);
    }
}

