/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.deepseek;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.deepseek.api.DeepSeekApi;
import org.springframework.ai.deepseek.api.ResponseFormat;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeepSeekChatOptions
implements ToolCallingChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="response_format")
    private ResponseFormat responseFormat;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="logprobs")
    private Boolean logprobs;
    @JsonProperty(value="top_logprobs")
    private Integer topLogprobs;
    @JsonProperty(value="tools")
    private List<DeepSeekApi.FunctionTool> tools;
    @JsonProperty(value="tool_choice")
    private Object toolChoice;
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonIgnore
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public List<DeepSeekApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<DeepSeekApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(Object toolChoice) {
        this.toolChoice = toolChoice;
    }

    @JsonIgnore
    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @Nullable
    @JsonIgnore
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public void setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public DeepSeekChatOptions copy() {
        return DeepSeekChatOptions.fromOptions(this);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.frequencyPenalty, this.logprobs, this.topLogprobs, this.maxTokens, this.presencePenalty, this.responseFormat, this.stop, this.temperature, this.topP, this.tools, this.toolChoice, this.toolCallbacks, this.toolNames, this.internalToolExecutionEnabled, this.toolContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeepSeekChatOptions other = (DeepSeekChatOptions)o;
        return Objects.equals(this.model, other.model) && Objects.equals(this.frequencyPenalty, other.frequencyPenalty) && Objects.equals(this.logprobs, other.logprobs) && Objects.equals(this.topLogprobs, other.topLogprobs) && Objects.equals(this.maxTokens, other.maxTokens) && Objects.equals(this.presencePenalty, other.presencePenalty) && Objects.equals(this.responseFormat, other.responseFormat) && Objects.equals(this.stop, other.stop) && Objects.equals(this.temperature, other.temperature) && Objects.equals(this.topP, other.topP) && Objects.equals(this.tools, other.tools) && Objects.equals(this.toolChoice, other.toolChoice) && Objects.equals(this.toolCallbacks, other.toolCallbacks) && Objects.equals(this.toolNames, other.toolNames) && Objects.equals(this.toolContext, other.toolContext) && Objects.equals(this.internalToolExecutionEnabled, other.internalToolExecutionEnabled);
    }

    public static DeepSeekChatOptions fromOptions(DeepSeekChatOptions fromOptions) {
        return DeepSeekChatOptions.builder().model(fromOptions.getModel()).frequencyPenalty(fromOptions.getFrequencyPenalty()).logprobs(fromOptions.getLogprobs()).topLogprobs(fromOptions.getTopLogprobs()).maxTokens(fromOptions.getMaxTokens()).presencePenalty(fromOptions.getPresencePenalty()).responseFormat(fromOptions.getResponseFormat()).stop((List<String>)(fromOptions.getStop() != null ? new ArrayList<String>(fromOptions.getStop()) : null)).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).tools(fromOptions.getTools()).toolChoice(fromOptions.getToolChoice()).toolCallbacks((List<ToolCallback>)(fromOptions.getToolCallbacks() != null ? new ArrayList<ToolCallback>(fromOptions.getToolCallbacks()) : null)).toolNames((Set<String>)(fromOptions.getToolNames() != null ? new HashSet<String>(fromOptions.getToolNames()) : null)).internalToolExecutionEnabled(fromOptions.getInternalToolExecutionEnabled()).toolContext((Map<String, Object>)(fromOptions.getToolContext() != null ? new HashMap<String, Object>(fromOptions.getToolContext()) : null)).build();
    }

    public static final class Builder {
        protected DeepSeekChatOptions options;

        public Builder() {
            this.options = new DeepSeekChatOptions();
        }

        public Builder(DeepSeekChatOptions options) {
            this.options = options;
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder model(DeepSeekApi.ChatModel deepseekAiChatModel) {
            this.options.model = deepseekAiChatModel.getName();
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.options.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.options.topLogprobs = topLogprobs;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder responseFormat(ResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder tools(List<DeepSeekApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder toolChoice(Object toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.toolNames.addAll(Set.of(toolNames));
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public DeepSeekChatOptions build() {
            return this.options;
        }
    }
}

