/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.deepseek.api;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.ai.deepseek.api.DeepSeekStreamFunctionCallingHelper;
import org.springframework.ai.deepseek.api.ResponseFormat;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.ChatModelDescription;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DeepSeekApi {
    public static final ChatModel DEFAULT_CHAT_MODEL = ChatModel.DEEPSEEK_CHAT;
    private static final Predicate<String> SSE_DONE_PREDICATE = "[DONE]"::equals;
    private final String completionsPath;
    private final String betaPrefixPath;
    private final RestClient restClient;
    private final WebClient webClient;
    private DeepSeekStreamFunctionCallingHelper chunkMerger = new DeepSeekStreamFunctionCallingHelper();

    public DeepSeekApi(String baseUrl, ApiKey apiKey, MultiValueMap<String, String> headers, String completionsPath, String betaPrefixPath, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Assert.hasText((String)completionsPath, (String)"Completions Path must not be null");
        Assert.hasText((String)betaPrefixPath, (String)"Beta feature path must not be null");
        Assert.notNull(headers, (String)"Headers must not be null");
        this.completionsPath = completionsPath;
        this.betaPrefixPath = betaPrefixPath;
        Consumer<HttpHeaders> finalHeaders = h -> {
            h.setBearerAuth(apiKey.getValue());
            h.setContentType(MediaType.APPLICATION_JSON);
            h.addAll(headers);
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(finalHeaders).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.baseUrl(baseUrl).defaultHeaders(finalHeaders).build();
    }

    public ResponseEntity<ChatCompletion> chatCompletionEntity(ChatCompletionRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((chatRequest.stream() == false ? 1 : 0) != 0, (String)"Request must set the stream property to false.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri(this.getEndpoint(chatRequest), new Object[0])).body((Object)chatRequest).retrieve().toEntity(ChatCompletion.class);
    }

    public Flux<ChatCompletionChunk> chatCompletionStream(ChatCompletionRequest chatRequest) {
        return this.chatCompletionStream(chatRequest, (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    public Flux<ChatCompletionChunk> chatCompletionStream(ChatCompletionRequest chatRequest, MultiValueMap<String, String> additionalHttpHeader) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((boolean)chatRequest.stream(), (String)"Request must set the stream property to true.");
        AtomicBoolean isInsideTool = new AtomicBoolean(false);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.getEndpoint(chatRequest), new Object[0])).headers(headers -> headers.addAll(additionalHttpHeader))).body((Publisher)Mono.just((Object)chatRequest), ChatCompletionRequest.class).retrieve().bodyToFlux(String.class).takeUntil(SSE_DONE_PREDICATE).filter(SSE_DONE_PREDICATE.negate()).map(content -> (ChatCompletionChunk)ModelOptionsUtils.jsonToObject((String)content, ChatCompletionChunk.class)).map(chunk -> {
            if (this.chunkMerger.isStreamingToolFunctionCall((ChatCompletionChunk)chunk)) {
                isInsideTool.set(true);
            }
            return chunk;
        }).windowUntil(chunk -> {
            if (isInsideTool.get() && this.chunkMerger.isStreamingToolFunctionCallFinish((ChatCompletionChunk)chunk)) {
                isInsideTool.set(false);
                return true;
            }
            return !isInsideTool.get();
        }).concatMapIterable(window -> {
            Mono monoChunk = window.reduce((Object)new ChatCompletionChunk(null, null, null, null, null, null, null, null), (previous, current) -> this.chunkMerger.merge((ChatCompletionChunk)previous, (ChatCompletionChunk)current));
            return List.of(monoChunk);
        }).flatMap(mono -> mono);
    }

    private String getEndpoint(ChatCompletionRequest request) {
        boolean isPrefix = request.messages.stream().map(ChatCompletionMessage::prefix).filter(Objects::nonNull).anyMatch(prefix -> prefix);
        String endpointPrefix = isPrefix ? this.betaPrefixPath : "";
        return endpointPrefix + this.completionsPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequest(@JsonProperty(value="messages") List<ChatCompletionMessage> messages, @JsonProperty(value="model") String model, @JsonProperty(value="frequency_penalty") Double frequencyPenalty, @JsonProperty(value="max_tokens") Integer maxTokens, @JsonProperty(value="presence_penalty") Double presencePenalty, @JsonProperty(value="response_format") ResponseFormat responseFormat, @JsonProperty(value="stop") List<String> stop, @JsonProperty(value="stream") Boolean stream, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="top_p") Double topP, @JsonProperty(value="logprobs") Boolean logprobs, @JsonProperty(value="top_logprobs") Integer topLogprobs, @JsonProperty(value="tools") List<FunctionTool> tools, @JsonProperty(value="tool_choice") Object toolChoice) {
        public ChatCompletionRequest(List<ChatCompletionMessage> messages, Boolean stream) {
            this(messages, null, null, null, null, null, null, stream, null, null, null, null, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Double temperature) {
            this(messages, model, null, null, null, null, null, false, temperature, null, null, null, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Double temperature, boolean stream) {
            this(messages, model, null, null, null, null, null, stream, temperature, null, null, null, null, null);
        }

        public static class ToolChoiceBuilder {
            public static final String AUTO = "auto";
            public static final String NONE = "none";

            public static Object FUNCTION(String functionName) {
                return Map.of("type", "function", "function", Map.of("name", functionName));
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ChatCompletion(@JsonProperty(value="id") String id, @JsonProperty(value="choices") List<Choice> choices, @JsonProperty(value="created") Long created, @JsonProperty(value="model") String model, @JsonProperty(value="system_fingerprint") String systemFingerprint, @JsonProperty(value="object") String object, @JsonProperty(value="usage") Usage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record Choice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="index") Integer index, @JsonProperty(value="message") ChatCompletionMessage message, @JsonProperty(value="logprobs") LogProbs logprobs) {
        }
    }

    public static final class Builder {
        private String baseUrl = "https://api.deepseek.com";
        private ApiKey apiKey;
        private MultiValueMap<String, String> headers = new LinkedMultiValueMap();
        private String completionsPath = "/chat/completions";
        private String betaPrefixPath = "/beta";
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private WebClient.Builder webClientBuilder = WebClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder baseUrl(String baseUrl) {
            Assert.hasText((String)baseUrl, (String)"baseUrl cannot be null or empty");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(ApiKey apiKey) {
            Assert.notNull((Object)apiKey, (String)"apiKey cannot be null");
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"simpleApiKey cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder headers(MultiValueMap<String, String> headers) {
            Assert.notNull(headers, (String)"headers cannot be null");
            this.headers = headers;
            return this;
        }

        public Builder completionsPath(String completionsPath) {
            Assert.hasText((String)completionsPath, (String)"completionsPath cannot be null or empty");
            this.completionsPath = completionsPath;
            return this;
        }

        public Builder betaPrefixPath(String betaPrefixPath) {
            Assert.hasText((String)betaPrefixPath, (String)"betaPrefixPath cannot be null or empty");
            this.betaPrefixPath = betaPrefixPath;
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"restClientBuilder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder webClientBuilder(WebClient.Builder webClientBuilder) {
            Assert.notNull((Object)webClientBuilder, (String)"webClientBuilder cannot be null");
            this.webClientBuilder = webClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"responseErrorHandler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public DeepSeekApi build() {
            Assert.notNull((Object)this.apiKey, (String)"apiKey must be set");
            return new DeepSeekApi(this.baseUrl, this.apiKey, this.headers, this.completionsPath, this.betaPrefixPath, this.restClientBuilder, this.webClientBuilder, this.responseErrorHandler);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ChatCompletionChunk(@JsonProperty(value="id") String id, @JsonProperty(value="choices") List<ChunkChoice> choices, @JsonProperty(value="created") Long created, @JsonProperty(value="model") String model, @JsonProperty(value="service_tier") String serviceTier, @JsonProperty(value="system_fingerprint") String systemFingerprint, @JsonProperty(value="object") String object, @JsonProperty(value="usage") Usage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record ChunkChoice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="index") Integer index, @JsonProperty(value="delta") ChatCompletionMessage delta, @JsonProperty(value="logprobs") LogProbs logprobs) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Usage(@JsonProperty(value="completion_tokens") Integer completionTokens, @JsonProperty(value="prompt_tokens") Integer promptTokens, @JsonProperty(value="total_tokens") Integer totalTokens, @JsonProperty(value="prompt_tokens_details") PromptTokensDetails promptTokensDetails) {
        public Usage(Integer completionTokens, Integer promptTokens, Integer totalTokens) {
            this(completionTokens, promptTokens, totalTokens, null);
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record PromptTokensDetails(@JsonProperty(value="cached_tokens") Integer cachedTokens) {
        }
    }

    public static enum ChatModel implements ChatModelDescription
    {
        DEEPSEEK_CHAT("deepseek-chat"),
        DEEPSEEK_REASONER("deepseek-reasoner");

        public final String value;

        private ChatModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record LogProbs(@JsonProperty(value="content") List<Content> content, @JsonProperty(value="refusal") List<Content> refusal) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record Content(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="bytes") List<Integer> probBytes, @JsonProperty(value="top_logprobs") List<TopLogProbs> topLogprobs) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            @JsonIgnoreProperties(ignoreUnknown=true)
            public record TopLogProbs(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="bytes") List<Integer> probBytes) {
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ChatCompletionMessage(@JsonProperty(value="content") Object rawContent, @JsonProperty(value="role") Role role, @JsonProperty(value="name") String name, @JsonProperty(value="tool_call_id") String toolCallId, @JsonProperty(value="tool_calls") @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY}) List<ToolCall> toolCalls, @JsonProperty(value="prefix") Boolean prefix, @JsonProperty(value="reasoning_content") String reasoningContent) {
        public ChatCompletionMessage(Object content, Role role) {
            this(content, role, null, null, null, null, null);
        }

        public ChatCompletionMessage(Object content, Role role, String name, String toolCallId, List<ToolCall> toolCalls) {
            this(content, role, name, toolCallId, toolCalls, null, null);
        }

        public String content() {
            if (this.rawContent == null) {
                return null;
            }
            Object object = this.rawContent;
            if (object instanceof String) {
                String text = (String)object;
                return text;
            }
            throw new IllegalStateException("The content is not a string!");
        }

        public static enum Role {
            SYSTEM,
            USER,
            ASSISTANT,
            TOOL;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record ChatCompletionFunction(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") String arguments) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record ToolCall(@JsonProperty(value="index") Integer index, @JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="function") ChatCompletionFunction function) {
            public ToolCall(String id, String type, ChatCompletionFunction function) {
                this(null, id, type, function);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class FunctionTool {
        @JsonProperty(value="type")
        private Type type = Type.FUNCTION;
        @JsonProperty(value="function")
        private Function function;

        public FunctionTool() {
        }

        public FunctionTool(Type type, Function function) {
            this.type = type;
            this.function = function;
        }

        public FunctionTool(Function function) {
            this(Type.FUNCTION, function);
        }

        public Type getType() {
            return this.type;
        }

        public Function getFunction() {
            return this.function;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setFunction(Function function) {
            this.function = function;
        }

        public static enum Type {
            FUNCTION;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class Function {
            @JsonProperty(value="description")
            private String description;
            @JsonProperty(value="name")
            private String name;
            @JsonProperty(value="parameters")
            private Map<String, Object> parameters;
            @JsonProperty(value="strict")
            Boolean strict;
            @JsonIgnore
            private String jsonSchema;

            private Function() {
            }

            public Function(String description, String name, Map<String, Object> parameters, Boolean strict) {
                this.description = description;
                this.name = name;
                this.parameters = parameters;
                this.strict = strict;
            }

            public Function(String description, String name, String jsonSchema) {
                this(description, name, ModelOptionsUtils.jsonToMap((String)jsonSchema), null);
            }

            public String getDescription() {
                return this.description;
            }

            public String getName() {
                return this.name;
            }

            public Map<String, Object> getParameters() {
                return this.parameters;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setParameters(Map<String, Object> parameters) {
                this.parameters = parameters;
            }

            public Boolean getStrict() {
                return this.strict;
            }

            public void setStrict(Boolean strict) {
                this.strict = strict;
            }

            public String getJsonSchema() {
                return this.jsonSchema;
            }

            public void setJsonSchema(String jsonSchema) {
                this.jsonSchema = jsonSchema;
                if (jsonSchema != null) {
                    this.parameters = ModelOptionsUtils.jsonToMap((String)jsonSchema);
                }
            }
        }
    }

    public static enum ChatCompletionFinishReason {
        STOP,
        LENGTH,
        CONTENT_FILTER,
        TOOL_CALLS,
        TOOL_CALL;

    }
}

