/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.LazyInitializationExcludeFilter;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.IncludeExcludeEndpointFilter;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.DefaultEndpointObjectNameFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.JmxEndpointProperties;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.jmx.EndpointObjectNameFactory;
import org.springframework.boot.actuate.endpoint.jmx.ExposableJmxEndpoint;
import org.springframework.boot.actuate.endpoint.jmx.JacksonJmxOperationResponseMapper;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointExporter;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.jmx.JmxOperationResponseMapper;
import org.springframework.boot.actuate.endpoint.jmx.annotation.JmxEndpointDiscoverer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={JmxAutoConfiguration.class, EndpointAutoConfiguration.class})
@EnableConfigurationProperties(value={JmxEndpointProperties.class})
@ConditionalOnProperty(prefix="spring.jmx", name={"enabled"}, havingValue="true")
public class JmxEndpointAutoConfiguration {
    private final ApplicationContext applicationContext;
    private final JmxEndpointProperties properties;

    public JmxEndpointAutoConfiguration(ApplicationContext applicationContext, JmxEndpointProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={JmxEndpointsSupplier.class})
    public JmxEndpointDiscoverer jmxAnnotationEndpointDiscoverer(ParameterValueMapper parameterValueMapper, ObjectProvider<OperationInvokerAdvisor> invokerAdvisors, ObjectProvider<EndpointFilter<ExposableJmxEndpoint>> filters) {
        return new JmxEndpointDiscoverer(this.applicationContext, parameterValueMapper, (Collection)invokerAdvisors.orderedStream().collect(Collectors.toList()), (Collection)filters.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    @ConditionalOnMissingBean(value={EndpointObjectNameFactory.class})
    public DefaultEndpointObjectNameFactory endpointObjectNameFactory(MBeanServer mBeanServer, Environment environment) {
        String contextId = ObjectUtils.getIdentityHexString((Object)this.applicationContext);
        return new DefaultEndpointObjectNameFactory(this.properties, environment, mBeanServer, contextId);
    }

    @Bean
    @ConditionalOnSingleCandidate(value=MBeanServer.class)
    public JmxEndpointExporter jmxMBeanExporter(MBeanServer mBeanServer, EndpointObjectNameFactory endpointObjectNameFactory, ObjectProvider<ObjectMapper> objectMapper, JmxEndpointsSupplier jmxEndpointsSupplier) {
        JacksonJmxOperationResponseMapper responseMapper = new JacksonJmxOperationResponseMapper((ObjectMapper)objectMapper.getIfAvailable());
        return new JmxEndpointExporter(mBeanServer, endpointObjectNameFactory, (JmxOperationResponseMapper)responseMapper, jmxEndpointsSupplier.getEndpoints());
    }

    @Bean
    public IncludeExcludeEndpointFilter<ExposableJmxEndpoint> jmxIncludeExcludePropertyEndpointFilter() {
        JmxEndpointProperties.Exposure exposure = this.properties.getExposure();
        return new IncludeExcludeEndpointFilter<ExposableJmxEndpoint>(ExposableJmxEndpoint.class, exposure.getInclude(), exposure.getExclude(), "*");
    }

    @Bean
    static LazyInitializationExcludeFilter eagerlyInitializeJmxEndpointExporter() {
        return LazyInitializationExcludeFilter.forBeanTypes((Class[])new Class[]{JmxEndpointExporter.class});
    }
}

