/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.otel.bridge.OtelBaggageManager;
import io.micrometer.tracing.otel.bridge.OtelCurrentTraceContext;
import io.micrometer.tracing.otel.bridge.Slf4JBaggageEventListener;
import io.micrometer.tracing.otel.propagation.BaggageTextMapPropagator;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.actuate.autoconfigure.tracing.CompositeTextMapPropagator;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.tracing.TracingProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

class OpenTelemetryPropagationConfigurations {
    OpenTelemetryPropagationConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    static class NoPropagation {
        NoPropagation() {
        }

        @Bean
        @ConditionalOnMissingBean
        TextMapPropagator noopTextMapPropagator() {
            return TextMapPropagator.noop();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="management.tracing.baggage", name={"enabled"}, matchIfMissing=true)
    @EnableConfigurationProperties(value={TracingProperties.class})
    static class PropagationWithBaggage {
        private final TracingProperties tracingProperties;

        PropagationWithBaggage(TracingProperties tracingProperties) {
            this.tracingProperties = tracingProperties;
        }

        @Bean
        @ConditionalOnEnabledTracing
        TextMapPropagator textMapPropagatorWithBaggage(OtelCurrentTraceContext otelCurrentTraceContext) {
            List<String> remoteFields = this.tracingProperties.getBaggage().getRemoteFields();
            BaggageTextMapPropagator baggagePropagator = new BaggageTextMapPropagator(remoteFields, (BaggageManager)new OtelBaggageManager((CurrentTraceContext)otelCurrentTraceContext, remoteFields, Collections.emptyList()));
            return CompositeTextMapPropagator.create(this.tracingProperties.getPropagation(), (TextMapPropagator)baggagePropagator);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="management.tracing.baggage.correlation", name={"enabled"}, matchIfMissing=true)
        Slf4JBaggageEventListener otelSlf4JBaggageEventListener() {
            return new Slf4JBaggageEventListener(this.tracingProperties.getBaggage().getCorrelation().getFields());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="management.tracing.baggage", name={"enabled"}, havingValue="false")
    @EnableConfigurationProperties(value={TracingProperties.class})
    static class PropagationWithoutBaggage {
        PropagationWithoutBaggage() {
        }

        @Bean
        @ConditionalOnEnabledTracing
        TextMapPropagator textMapPropagator(TracingProperties properties) {
            return CompositeTextMapPropagator.create(properties.getPropagation(), null);
        }
    }
}

