/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Valve;
import org.apache.catalina.valves.AccessLogValve;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfigurationsImportSelector;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.mvc.ManagementErrorEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoints;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.hateoas.HypermediaHttpMessageConverterConfiguration;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.boot.web.servlet.ErrorPage;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.hateoas.LinkDiscoverer;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@Configuration
@EnableWebMvc
@Import(value={ManagementContextConfigurationsImportSelector.class})
public class EndpointWebMvcChildContextConfiguration {
    @Bean(name={"dispatcherServlet"})
    public DispatcherServlet dispatcherServlet() {
        DispatcherServlet dispatcherServlet = new DispatcherServlet();
        dispatcherServlet.setDetectAllHandlerAdapters(false);
        dispatcherServlet.setDetectAllHandlerExceptionResolvers(false);
        dispatcherServlet.setDetectAllHandlerMappings(false);
        dispatcherServlet.setDetectAllViewResolvers(false);
        return dispatcherServlet;
    }

    @Bean(name={"handlerMapping"})
    public CompositeHandlerMapping compositeHandlerMapping() {
        return new CompositeHandlerMapping();
    }

    @Bean(name={"handlerAdapter"})
    public CompositeHandlerAdapter compositeHandlerAdapter() {
        return new CompositeHandlerAdapter();
    }

    @Bean(name={"handlerExceptionResolver"})
    public CompositeHandlerExceptionResolver compositeHandlerExceptionResolver() {
        return new CompositeHandlerExceptionResolver();
    }

    @Bean
    public ServerCustomization serverCustomization() {
        return new ServerCustomization();
    }

    @Bean
    public UndertowAccessLogCustomizer undertowAccessLogCustomizer() {
        return new UndertowAccessLogCustomizer();
    }

    @Bean
    @ConditionalOnClass(name={"org.apache.catalina.valves.AccessLogValve"})
    public TomcatAccessLogCustomizer tomcatAccessLogCustomizer() {
        return new TomcatAccessLogCustomizer();
    }

    @Bean
    @ConditionalOnBean(value={ErrorAttributes.class})
    public ManagementErrorEndpoint errorEndpoint(ErrorAttributes errorAttributes) {
        return new ManagementErrorEndpoint(errorAttributes);
    }

    static class UndertowAccessLogCustomizer
    extends AccessLogCustomizer<UndertowEmbeddedServletContainerFactory> {
        UndertowAccessLogCustomizer() {
            super(UndertowEmbeddedServletContainerFactory.class);
        }

        @Override
        public void customize(UndertowEmbeddedServletContainerFactory container) {
            container.setAccessLogPrefix(this.customizePrefix(container.getAccessLogPrefix()));
        }
    }

    static class TomcatAccessLogCustomizer
    extends AccessLogCustomizer<TomcatEmbeddedServletContainerFactory> {
        TomcatAccessLogCustomizer() {
            super(TomcatEmbeddedServletContainerFactory.class);
        }

        @Override
        public void customize(TomcatEmbeddedServletContainerFactory container) {
            AccessLogValve accessLogValve = this.findAccessLogValve(container);
            if (accessLogValve == null) {
                return;
            }
            accessLogValve.setPrefix(this.customizePrefix(accessLogValve.getPrefix()));
        }

        private AccessLogValve findAccessLogValve(TomcatEmbeddedServletContainerFactory container) {
            for (Valve engineValve : container.getEngineValves()) {
                if (!(engineValve instanceof AccessLogValve)) continue;
                return (AccessLogValve)engineValve;
            }
            return null;
        }
    }

    static abstract class AccessLogCustomizer<T extends EmbeddedServletContainerFactory>
    implements EmbeddedServletContainerCustomizer,
    Ordered {
        private final Class<T> factoryClass;

        AccessLogCustomizer(Class<T> factoryClass) {
            this.factoryClass = factoryClass;
        }

        protected String customizePrefix(String prefix) {
            return "management_" + prefix;
        }

        public int getOrder() {
            return 1;
        }

        public void customize(ConfigurableEmbeddedServletContainer container) {
            if (this.factoryClass.isInstance(container)) {
                this.customize((EmbeddedServletContainerFactory)this.factoryClass.cast(container));
            }
        }

        abstract void customize(T var1);
    }

    static class CompositeHandlerExceptionResolver
    implements HandlerExceptionResolver {
        @Autowired
        private ListableBeanFactory beanFactory;
        private List<HandlerExceptionResolver> resolvers;

        CompositeHandlerExceptionResolver() {
        }

        private List<HandlerExceptionResolver> extractResolvers() {
            ArrayList<HandlerExceptionResolver> list = new ArrayList<HandlerExceptionResolver>();
            list.addAll(this.beanFactory.getBeansOfType(HandlerExceptionResolver.class).values());
            list.remove(this);
            AnnotationAwareOrderComparator.sort(list);
            return list;
        }

        public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
            if (this.resolvers == null) {
                this.resolvers = this.extractResolvers();
            }
            for (HandlerExceptionResolver mapping : this.resolvers) {
                ModelAndView mav = mapping.resolveException(request, response, handler, ex);
                if (mav == null) continue;
                return mav;
            }
            return null;
        }
    }

    static class CompositeHandlerAdapter
    implements HandlerAdapter {
        @Autowired
        private ListableBeanFactory beanFactory;
        private List<HandlerAdapter> adapters;

        CompositeHandlerAdapter() {
        }

        private List<HandlerAdapter> extractAdapters() {
            ArrayList<HandlerAdapter> list = new ArrayList<HandlerAdapter>();
            list.addAll(this.beanFactory.getBeansOfType(HandlerAdapter.class).values());
            list.remove(this);
            AnnotationAwareOrderComparator.sort(list);
            return list;
        }

        public boolean supports(Object handler) {
            if (this.adapters == null) {
                this.adapters = this.extractAdapters();
            }
            for (HandlerAdapter mapping : this.adapters) {
                if (!mapping.supports(handler)) continue;
                return true;
            }
            return false;
        }

        public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            if (this.adapters == null) {
                this.adapters = this.extractAdapters();
            }
            for (HandlerAdapter mapping : this.adapters) {
                if (!mapping.supports(handler)) continue;
                return mapping.handle(request, response, handler);
            }
            return null;
        }

        public long getLastModified(HttpServletRequest request, Object handler) {
            if (this.adapters == null) {
                this.adapters = this.extractAdapters();
            }
            for (HandlerAdapter mapping : this.adapters) {
                if (!mapping.supports(handler)) continue;
                return mapping.getLastModified(request, handler);
            }
            return 0L;
        }
    }

    static class CompositeHandlerMapping
    implements HandlerMapping {
        @Autowired
        private ListableBeanFactory beanFactory;
        private List<HandlerMapping> mappings;

        CompositeHandlerMapping() {
        }

        public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
            if (this.mappings == null) {
                this.mappings = this.extractMappings();
            }
            for (HandlerMapping mapping : this.mappings) {
                HandlerExecutionChain handler = mapping.getHandler(request);
                if (handler == null) continue;
                return handler;
            }
            return null;
        }

        private List<HandlerMapping> extractMappings() {
            ArrayList<HandlerMapping> list = new ArrayList<HandlerMapping>();
            list.addAll(this.beanFactory.getBeansOfType(HandlerMapping.class).values());
            list.remove(this);
            AnnotationAwareOrderComparator.sort(list);
            return list;
        }
    }

    static class ServerCustomization
    implements EmbeddedServletContainerCustomizer,
    Ordered {
        @Autowired
        private ListableBeanFactory beanFactory;
        private ManagementServerProperties managementServerProperties;
        private ServerProperties server;

        ServerCustomization() {
        }

        public int getOrder() {
            return 0;
        }

        public void customize(ConfigurableEmbeddedServletContainer container) {
            if (this.managementServerProperties == null) {
                this.managementServerProperties = (ManagementServerProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ManagementServerProperties.class);
                this.server = (ServerProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ServerProperties.class);
            }
            this.server.customize(container);
            container.setErrorPages(Collections.emptySet());
            container.setContextPath("");
            container.setPort(this.managementServerProperties.getPort().intValue());
            if (this.managementServerProperties.getSsl() != null) {
                container.setSsl(this.managementServerProperties.getSsl());
            }
            container.setServerHeader(this.server.getServerHeader());
            container.setAddress(this.managementServerProperties.getAddress());
            container.addErrorPages(new ErrorPage[]{new ErrorPage(this.server.getError().getPath())});
        }
    }

    @Configuration
    @ConditionalOnClass(value={LinkDiscoverer.class})
    @Import(value={HypermediaHttpMessageConverterConfiguration.class})
    @EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
    static class HypermediaConfiguration {
        HypermediaConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={EnableWebSecurity.class, Filter.class})
    @ConditionalOnBean(name={"springSecurityFilterChain"}, search=SearchStrategy.ANCESTORS)
    public static class EndpointWebMvcChildContextSecurityConfiguration {
        @Bean
        public Filter springSecurityFilterChain(HierarchicalBeanFactory beanFactory) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            return (Filter)parent.getBean("springSecurityFilterChain", Filter.class);
        }
    }

    @Configuration
    protected static class EndpointHandlerMappingConfiguration {
        protected EndpointHandlerMappingConfiguration() {
        }

        @Autowired
        public void handlerMapping(MvcEndpoints endpoints, ListableBeanFactory beanFactory, EndpointHandlerMapping mapping) {
            mapping.setDetectHandlerMethodsInAncestorContexts(true);
        }
    }
}

