/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import org.springframework.boot.actuate.autoconfigure.ActuatorMetricWriter;
import org.springframework.boot.actuate.autoconfigure.ExportMetricReader;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.buffer.BufferCounterService;
import org.springframework.boot.actuate.metrics.buffer.BufferGaugeService;
import org.springframework.boot.actuate.metrics.buffer.BufferMetricReader;
import org.springframework.boot.actuate.metrics.buffer.CounterBuffers;
import org.springframework.boot.actuate.metrics.buffer.GaugeBuffers;
import org.springframework.boot.actuate.metrics.repository.InMemoryMetricRepository;
import org.springframework.boot.actuate.metrics.repository.InMemoryMultiMetricRepository;
import org.springframework.boot.actuate.metrics.writer.DefaultCounterService;
import org.springframework.boot.actuate.metrics.writer.DefaultGaugeService;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetricRepositoryAutoConfiguration {

    @Configuration
    @ConditionalOnJava(value=ConditionalOnJava.JavaVersion.EIGHT, range=ConditionalOnJava.Range.OLDER_THAN)
    @ConditionalOnMissingBean(name={"actuatorMetricRepository"})
    static class LegacyMetricRepositoryConfiguration {
        LegacyMetricRepositoryConfiguration() {
        }

        @Bean
        @ExportMetricReader
        @ActuatorMetricWriter
        public InMemoryMetricRepository actuatorMetricRepository() {
            return new InMemoryMetricRepository();
        }

        @Bean
        @ExportMetricReader
        @ActuatorMetricWriter
        public InMemoryMultiMetricRepository actuatorMultiMetricRepository(InMemoryMetricRepository actuatorMetricRepository) {
            return new InMemoryMultiMetricRepository(actuatorMetricRepository);
        }
    }

    @Configuration
    @ConditionalOnJava(value=ConditionalOnJava.JavaVersion.EIGHT)
    @ConditionalOnMissingBean(value={GaugeService.class})
    static class FastMetricServicesConfiguration {
        FastMetricServicesConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public CounterBuffers counterBuffers() {
            return new CounterBuffers();
        }

        @Bean
        @ConditionalOnMissingBean
        public GaugeBuffers gaugeBuffers() {
            return new GaugeBuffers();
        }

        @Bean
        @ExportMetricReader
        @ConditionalOnMissingBean
        public BufferMetricReader actuatorMetricReader(CounterBuffers counters, GaugeBuffers gauges) {
            return new BufferMetricReader(counters, gauges);
        }

        @Bean
        @ConditionalOnMissingBean(value={CounterService.class})
        public BufferCounterService counterService(CounterBuffers writer) {
            return new BufferCounterService(writer);
        }

        @Bean
        @ConditionalOnMissingBean(value={GaugeService.class})
        public BufferGaugeService gaugeService(GaugeBuffers writer) {
            return new BufferGaugeService(writer);
        }
    }

    @Configuration
    @ConditionalOnJava(value=ConditionalOnJava.JavaVersion.EIGHT, range=ConditionalOnJava.Range.OLDER_THAN)
    @ConditionalOnMissingBean(value={GaugeService.class})
    static class LegacyMetricServicesConfiguration {
        private final MetricWriter writer;

        LegacyMetricServicesConfiguration(@ActuatorMetricWriter MetricWriter writer) {
            this.writer = writer;
        }

        @Bean
        @ConditionalOnMissingBean(value={CounterService.class})
        public DefaultCounterService counterService() {
            return new DefaultCounterService(this.writer);
        }

        @Bean
        @ConditionalOnMissingBean(value={GaugeService.class})
        public DefaultGaugeService gaugeService() {
            return new DefaultGaugeService(this.writer);
        }
    }
}

