/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.writer;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;

public class DefaultGaugeService
implements GaugeService {
    private final MetricWriter writer;
    private final ConcurrentHashMap<String, String> names = new ConcurrentHashMap();

    public DefaultGaugeService(MetricWriter writer) {
        this.writer = writer;
    }

    @Override
    public void submit(String metricName, double value) {
        this.writer.set(new Metric<Double>(this.wrap(metricName), value));
    }

    private String wrap(String metricName) {
        String cached = this.names.get(metricName);
        if (cached != null) {
            return cached;
        }
        if (metricName.startsWith("gauge") || metricName.startsWith("histogram") || metricName.startsWith("timer")) {
            return metricName;
        }
        String name = "gauge." + metricName;
        this.names.put(metricName, name);
        return name;
    }
}

