/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.http.ApiVersion;
import org.springframework.boot.actuate.health.CompositeHealth;
import org.springframework.boot.actuate.health.ContributorRegistry;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthComponent;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.actuate.health.NamedContributors;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.actuate.health.SystemHealth;
import org.springframework.util.Assert;

abstract class HealthEndpointSupport<C, T> {
    static final Health DEFAULT_HEALTH = Health.up().build();
    private final ContributorRegistry<C> registry;
    private final HealthEndpointGroups groups;

    HealthEndpointSupport(ContributorRegistry<C> registry, HealthEndpointGroups groups) {
        Assert.notNull(registry, (String)"Registry must not be null");
        Assert.notNull((Object)groups, (String)"Groups must not be null");
        this.registry = registry;
        this.groups = groups;
    }

    HealthResult<T> getHealth(ApiVersion apiVersion, SecurityContext securityContext, boolean showAll, String ... path) {
        HealthEndpointGroup group;
        HealthEndpointGroup healthEndpointGroup = group = path.length > 0 ? this.groups.get(path[0]) : null;
        if (group != null) {
            return this.getHealth(apiVersion, group, securityContext, showAll, path, 1);
        }
        return this.getHealth(apiVersion, this.groups.getPrimary(), securityContext, showAll, path, 0);
    }

    private HealthResult<T> getHealth(ApiVersion apiVersion, HealthEndpointGroup group, SecurityContext securityContext, boolean showAll, String[] path, int pathOffset) {
        boolean isRoot;
        boolean showComponents = showAll || group.showComponents(securityContext);
        boolean showDetails = showAll || group.showDetails(securityContext);
        boolean isSystemHealth = group == this.groups.getPrimary() && pathOffset == 0;
        boolean bl = isRoot = path.length - pathOffset == 0;
        if (!showComponents && !isRoot) {
            return null;
        }
        Object contributor = this.getContributor(path, pathOffset);
        T health = this.getContribution(apiVersion, group, contributor, showComponents, showDetails, isSystemHealth ? this.groups.getNames() : null, false);
        return health != null ? new HealthResult<T>(health, group) : null;
    }

    private Object getContributor(String[] path, int pathOffset) {
        ContributorRegistry<C> contributor = this.registry;
        while (pathOffset < path.length) {
            if (!(contributor instanceof NamedContributors)) {
                return null;
            }
            contributor = ((NamedContributors)contributor).getContributor(path[pathOffset]);
            ++pathOffset;
        }
        return contributor;
    }

    private T getContribution(ApiVersion apiVersion, HealthEndpointGroup group, Object contributor, boolean showComponents, boolean showDetails, Set<String> groupNames, boolean isNested) {
        if (contributor instanceof NamedContributors) {
            return this.getAggregateHealth(apiVersion, group, (NamedContributors)contributor, showComponents, showDetails, groupNames, isNested);
        }
        return contributor != null ? (T)this.getHealth(contributor, showDetails) : null;
    }

    private T getAggregateHealth(ApiVersion apiVersion, HealthEndpointGroup group, NamedContributors<C> namedContributors, boolean showComponents, boolean showDetails, Set<String> groupNames, boolean isNested) {
        LinkedHashMap<String, T> contributions = new LinkedHashMap<String, T>();
        for (NamedContributor namedContributor : namedContributors) {
            T contribution;
            String name = namedContributor.getName();
            Object contributor = namedContributor.getContributor();
            if (!group.isMember(name) && !isNested || (contribution = this.getContribution(apiVersion, group, contributor, showComponents, showDetails, null, true)) == null) continue;
            contributions.put(name, contribution);
        }
        if (contributions.isEmpty()) {
            return null;
        }
        return (T)this.aggregateContributions(apiVersion, contributions, group.getStatusAggregator(), showComponents, groupNames);
    }

    protected abstract T getHealth(C var1, boolean var2);

    protected abstract T aggregateContributions(ApiVersion var1, Map<String, T> var2, StatusAggregator var3, boolean var4, Set<String> var5);

    protected final CompositeHealth getCompositeHealth(ApiVersion apiVersion, Map<String, HealthComponent> components, StatusAggregator statusAggregator, boolean showComponents, Set<String> groupNames) {
        Map<String, HealthComponent> instances;
        Status status = statusAggregator.getAggregateStatus(components.values().stream().map(this::getStatus).collect(Collectors.toSet()));
        Map<String, HealthComponent> map = instances = showComponents ? components : null;
        if (groupNames != null) {
            return new SystemHealth(apiVersion, status, instances, groupNames);
        }
        return new CompositeHealth(apiVersion, status, instances);
    }

    private Status getStatus(HealthComponent component) {
        return component != null ? component.getStatus() : Status.UNKNOWN;
    }

    static class HealthResult<T> {
        private final T health;
        private final HealthEndpointGroup group;

        HealthResult(T health, HealthEndpointGroup group) {
            this.health = health;
            this.group = group;
        }

        T getHealth() {
            return this.health;
        }

        HealthEndpointGroup getGroup() {
            return this.group;
        }
    }
}

