/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.util.Objects;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Cache {
    protected final Format format;

    Cache(Format format) {
        this.format = format;
    }

    public Volume getVolume() {
        return this.format.equals((Object)Format.VOLUME) ? (Volume)this : null;
    }

    public static Cache volume(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return new Volume(name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cache other = (Cache)obj;
        return Objects.equals((Object)this.format, (Object)other.format);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)((Object)this.format));
    }

    public static class Volume
    extends Cache {
        private final String name;

        Volume(String name) {
            super(Format.VOLUME);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Volume other = (Volume)obj;
            return Objects.equals(this.name, other.name);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.name);
            return result;
        }
    }

    public static enum Format {
        VOLUME;

    }
}

