/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.filewatch;

import java.io.File;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ChangedFile {
    private final File sourceFolder;
    private final File file;
    private final Type type;

    public ChangedFile(File sourceFolder, File file, Type type) {
        Assert.notNull((Object)sourceFolder, (String)"SourceFolder must not be null");
        Assert.notNull((Object)file, (String)"File must not be null");
        Assert.notNull((Object)((Object)type), (String)"Type must not be null");
        this.sourceFolder = sourceFolder;
        this.file = file;
        this.type = type;
    }

    public File getFile() {
        return this.file;
    }

    public Type getType() {
        return this.type;
    }

    public String getRelativeName() {
        File folder = this.sourceFolder.getAbsoluteFile();
        File file = this.file.getAbsoluteFile();
        String folderName = StringUtils.cleanPath((String)folder.getPath());
        String fileName = StringUtils.cleanPath((String)file.getPath());
        Assert.state((boolean)fileName.startsWith(folderName), (String)("The file " + fileName + " is not contained in the source folder " + folderName));
        return fileName.substring(folderName.length() + 1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ChangedFile) {
            ChangedFile other = (ChangedFile)obj;
            return this.file.equals(other.file) && this.type.equals((Object)other.type);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.file.hashCode() * 31 + this.type.hashCode();
    }

    public String toString() {
        return this.file + " (" + (Object)((Object)this.type) + ")";
    }

    public static enum Type {
        ADD,
        MODIFY,
        DELETE;

    }
}

