/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class RestartScopeInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        applicationContext.getBeanFactory().registerScope("restart", (Scope)new RestartScope());
    }

    private static final class RestartScope
    implements Scope {
        private RestartScope() {
        }

        public Object get(String name, ObjectFactory<?> objectFactory) {
            return Restarter.getInstance().getOrAddAttribute(name, objectFactory);
        }

        public Object remove(String name) {
            return Restarter.getInstance().removeAttribute(name);
        }

        public void registerDestructionCallback(String name, Runnable callback) {
        }

        public Object resolveContextualObject(String key) {
            return null;
        }

        public String getConversationId() {
            return null;
        }
    }
}

