/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.metrics.buffering;

import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import org.springframework.boot.context.metrics.buffering.BufferedStartupStep;
import org.springframework.boot.context.metrics.buffering.StartupTimeline;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.metrics.StartupStep;
import org.springframework.util.Assert;

public class BufferingApplicationStartup
implements ApplicationStartup {
    private Instant recordingStartTime;
    private long recordingStartNanos;
    private long currentSequenceId = 0L;
    private final Deque<Long> currentSteps;
    private final BlockingQueue<BufferedStartupStep> recordedSteps;
    private Predicate<StartupStep> stepFilters = step -> true;

    public BufferingApplicationStartup(int capacity) {
        this.currentSteps = new ArrayDeque<Long>();
        this.currentSteps.offerFirst(this.currentSequenceId);
        this.recordedSteps = new LinkedBlockingQueue<BufferedStartupStep>(capacity);
        this.startRecording();
    }

    public void startRecording() {
        Assert.state((boolean)this.recordedSteps.isEmpty(), (String)"Cannot restart recording once steps have been buffered.");
        this.recordingStartTime = Instant.now();
        this.recordingStartNanos = this.getCurrentTime();
    }

    public void addFilter(Predicate<StartupStep> filter) {
        this.stepFilters = this.stepFilters.and(filter);
    }

    public StartupTimeline getBufferedTimeline() {
        return new StartupTimeline(this.recordingStartTime, this.recordingStartNanos, this.recordedSteps);
    }

    public StartupTimeline drainBufferedTimeline() {
        ArrayList<BufferedStartupStep> steps = new ArrayList<BufferedStartupStep>(this.recordedSteps.size());
        this.recordedSteps.drainTo(steps);
        return new StartupTimeline(this.recordingStartTime, this.recordingStartNanos, steps);
    }

    public StartupStep start(String name) {
        BufferedStartupStep step = new BufferedStartupStep(++this.currentSequenceId, name, this.currentSteps.peekFirst(), this::record);
        step.recordStartTime(this.getCurrentTime());
        this.currentSteps.offerFirst(this.currentSequenceId);
        return step;
    }

    private void record(BufferedStartupStep step) {
        step.recordEndTime(this.getCurrentTime());
        if (this.stepFilters.test(step)) {
            this.recordedSteps.offer(step);
        }
        this.currentSteps.removeFirst();
    }

    private long getCurrentTime() {
        return System.nanoTime();
    }
}

