/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.registry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.alibaba.nacos.registry.NacosRegistration;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class NacosAutoServiceRegistration
extends AbstractAutoServiceRegistration<NacosRegistration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosAutoServiceRegistration.class);
    @Autowired
    private NacosRegistration registration;

    public NacosAutoServiceRegistration(ServiceRegistry<NacosRegistration> serviceRegistry, AutoServiceRegistrationProperties autoServiceRegistrationProperties, NacosRegistration registration) {
        super(serviceRegistry, autoServiceRegistrationProperties);
        this.registration = registration;
    }

    @Deprecated
    public void setPort(int port) {
        this.getPort().set(port);
    }

    protected NacosRegistration getRegistration() {
        if (this.registration.getPort() < 0 && this.getPort().get() > 0) {
            this.registration.setPort(this.getPort().get());
        }
        Assert.isTrue((this.registration.getPort() > 0 ? 1 : 0) != 0, (String)"service.port has not been set");
        return this.registration;
    }

    protected NacosRegistration getManagementRegistration() {
        return null;
    }

    protected void register() {
        if (!this.registration.getNacosDiscoveryProperties().isRegisterEnabled()) {
            LOGGER.debug("Registration disabled.");
            return;
        }
        if (this.registration.getPort() < 0) {
            this.registration.setPort(this.getPort().get());
        }
        super.register();
    }

    protected void registerManagement() {
        if (!this.registration.getNacosDiscoveryProperties().isRegisterEnabled()) {
            return;
        }
        super.registerManagement();
    }

    protected int getConfiguredPort() {
        return this.getPort().get();
    }

    protected void setConfiguredPort(int port) {
        this.getPort().set(port);
    }

    protected Object getConfiguration() {
        return this.registration.getNacosDiscoveryProperties();
    }

    protected boolean isEnabled() {
        return this.registration.getNacosDiscoveryProperties().isRegisterEnabled();
    }

    protected String getAppName() {
        String appName = this.registration.getNacosDiscoveryProperties().getService();
        return StringUtils.isEmpty((Object)appName) ? super.getAppName() : appName;
    }
}

