/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class HostRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    private PathMatcher pathMatcher = new AntPathMatcher(".");

    public HostRoutePredicateFactory() {
        super(Config.class);
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("patterns");
    }

    @Override
    public ShortcutConfigurable.ShortcutType shortcutType() {
        return ShortcutConfigurable.ShortcutType.GATHER_LIST;
    }

    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        return new GatewayPredicate(){

            @Override
            public boolean test(ServerWebExchange exchange) {
                String host = exchange.getRequest().getHeaders().getFirst("Host");
                String match = null;
                for (int i = 0; i < config.getPatterns().size(); ++i) {
                    String pattern = config.getPatterns().get(i);
                    if (!HostRoutePredicateFactory.this.pathMatcher.match(pattern, host)) continue;
                    match = pattern;
                    break;
                }
                if (match != null) {
                    Map variables = HostRoutePredicateFactory.this.pathMatcher.extractUriTemplateVariables(match, host);
                    ServerWebExchangeUtils.putUriTemplateVariables(exchange, variables);
                    return true;
                }
                return false;
            }

            @Override
            public Object getConfig() {
                return config;
            }

            public String toString() {
                return String.format("Hosts: %s", config.getPatterns());
            }
        };
    }

    @Validated
    public static class Config {
        private List<String> patterns = new ArrayList<String>();

        public List<String> getPatterns() {
            return this.patterns;
        }

        public Config setPatterns(List<String> patterns) {
            this.patterns = patterns;
            return this;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("patterns", this.patterns).toString();
        }
    }
}

