/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.support;

import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public final class VersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(VersionInfo.class);
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final String VERSION_PROPERTIES = "versions.properties";
    public static final String VERSION_SPRING_DATA_ELASTICSEARCH = "version.spring-data-elasticsearch";
    public static final String VERSION_ELASTICSEARCH_CLIENT = "version.elasticsearch-client";

    public static void logVersions(@Nullable String clusterVersion) {
        if (!initialized.getAndSet(true)) {
            try {
                InputStream resource = VersionInfo.class.getClassLoader().getResourceAsStream(VERSION_PROPERTIES);
                if (resource != null) {
                    Properties properties = new Properties();
                    properties.load(resource);
                    String versionSpringDataElasticsearch = properties.getProperty(VERSION_SPRING_DATA_ELASTICSEARCH);
                    Version versionESBuilt = Version.fromString((String)properties.getProperty(VERSION_ELASTICSEARCH_CLIENT));
                    Version versionESUsed = Version.CURRENT;
                    Version versionESCluster = clusterVersion != null ? Version.fromString((String)clusterVersion) : null;
                    LOG.info("Version Spring Data Elasticsearch: {}", (Object)versionSpringDataElasticsearch.toString());
                    LOG.info("Version Elasticsearch Client in build: {}", (Object)versionESBuilt.toString());
                    LOG.info("Version Elasticsearch Client used: {}", (Object)versionESUsed.toString());
                    if (VersionInfo.differInMajorOrMinor(versionESBuilt, versionESUsed)) {
                        LOG.warn("Version mismatch in between Elasticsearch Clients build/use: {} - {}", (Object)versionESBuilt, (Object)versionESUsed);
                    }
                    if (versionESCluster != null) {
                        LOG.info("Version Elasticsearch cluster: {}", (Object)versionESCluster.toString());
                        if (VersionInfo.differInMajorOrMinor(versionESUsed, versionESCluster)) {
                            LOG.warn("Version mismatch in between Elasticsearch Client and Cluster: {} - {}", (Object)versionESUsed, (Object)versionESCluster);
                        }
                    }
                } else {
                    LOG.warn("cannot load {}", (Object)VERSION_PROPERTIES);
                }
            }
            catch (Exception e) {
                LOG.warn("Could not log version info: {} - {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            }
        }
    }

    public static Properties versionProperties() throws Exception {
        try {
            InputStream resource = VersionInfo.class.getClassLoader().getResourceAsStream(VERSION_PROPERTIES);
            if (resource != null) {
                Properties properties = new Properties();
                properties.load(resource);
                return properties;
            }
            throw new IllegalStateException("Resource not found");
        }
        catch (Exception e) {
            LOG.error("Could not load {}", (Object)VERSION_PROPERTIES, (Object)e);
            throw e;
        }
    }

    private static boolean differInMajorOrMinor(Version version1, Version version2) {
        return version1.major != version2.major || version1.minor != version2.minor;
    }

    private VersionInfo() {
    }
}

