/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.net.InetSocketAddress;
import java.time.Instant;
import org.springframework.data.elasticsearch.client.InetSocketAddressParser;
import org.springframework.util.Assert;

public class ElasticsearchHost {
    public static final int DEFAULT_PORT = 9200;
    private final InetSocketAddress endpoint;
    private final State state;
    private final Instant timestamp;

    public ElasticsearchHost(InetSocketAddress endpoint, State state) {
        Assert.notNull((Object)endpoint, (String)"Host must not be null");
        Assert.notNull((Object)((Object)state), (String)"State must not be null");
        this.endpoint = endpoint;
        this.state = state;
        this.timestamp = Instant.now();
    }

    public static ElasticsearchHost online(InetSocketAddress host) {
        return new ElasticsearchHost(host, State.ONLINE);
    }

    public static ElasticsearchHost offline(InetSocketAddress host) {
        return new ElasticsearchHost(host, State.OFFLINE);
    }

    public static InetSocketAddress parse(String hostAndPort) {
        return InetSocketAddressParser.parse(hostAndPort, 9200);
    }

    public boolean isOnline() {
        return State.ONLINE.equals((Object)this.state);
    }

    public InetSocketAddress getEndpoint() {
        return this.endpoint;
    }

    public State getState() {
        return this.state;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "ElasticsearchHost(" + this.endpoint + ", " + this.state.name() + ")";
    }

    public static enum State {
        ONLINE,
        OFFLINE,
        UNKNOWN;

    }
}

