/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.Map;
import org.springframework.data.jdbc.core.convert.SqlGenerator;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.util.ConcurrentReferenceHashMap;

public class SqlGeneratorSource {
    private final Map<Class<?>, SqlGenerator> CACHE = new ConcurrentReferenceHashMap();
    private final RelationalMappingContext context;

    SqlGenerator getSqlGenerator(Class<?> domainType) {
        return this.CACHE.computeIfAbsent(domainType, t -> new SqlGenerator(this.context, (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(t)));
    }

    public SqlGeneratorSource(RelationalMappingContext context) {
        this.context = context;
    }
}

