/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping;

import org.springframework.lang.Nullable;

public interface AggregateReference<T, ID> {
    public static <T, ID> AggregateReference<T, ID> to(ID id) {
        return new IdOnlyAggregateReference(id);
    }

    @Nullable
    public ID getId();

    public static class IdOnlyAggregateReference<T, ID>
    implements AggregateReference<T, ID> {
        private final ID id;

        @Override
        public ID getId() {
            return this.id;
        }

        public IdOnlyAggregateReference(ID id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdOnlyAggregateReference)) {
                return false;
            }
            IdOnlyAggregateReference other = (IdOnlyAggregateReference)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ID this$id = this.getId();
            ID other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IdOnlyAggregateReference;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "AggregateReference.IdOnlyAggregateReference(id=" + this.getId() + ")";
        }
    }
}

