/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.NameRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;
import org.springframework.lang.Nullable;

class ColumnVisitor
extends TypedSubtreeVisitor<Column> {
    private final RenderContext context;
    private final RenderTarget target;
    private final boolean considerTablePrefix;
    @Nullable
    private SqlIdentifier tableName;

    ColumnVisitor(RenderContext context, boolean considerTablePrefix, RenderTarget target) {
        this.context = context;
        this.target = target;
        this.considerTablePrefix = considerTablePrefix;
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(Column segment) {
        SqlIdentifier column = this.context.getNamingStrategy().getName(segment);
        CharSequence name = this.considerTablePrefix && this.tableName != null ? NameRenderer.render(this.context, SqlIdentifier.from(this.tableName, column)) : NameRenderer.render(this.context, segment);
        this.target.onRendered(name);
        return super.leaveMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (segment instanceof TableLike) {
            this.tableName = this.context.getNamingStrategy().getReferenceName((TableLike)segment);
        }
        return super.leaveNested(segment);
    }
}

