/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Map;
import java.util.TreeMap;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;

class ColumInfosBuilder {
    private final AggregatePath basePath;
    private final Map<AggregatePath, AggregatePath.ColumnInfo> columnInfoMap = new TreeMap<AggregatePath, AggregatePath.ColumnInfo>();

    ColumInfosBuilder(AggregatePath basePath) {
        this.basePath = basePath;
    }

    void add(AggregatePath path, SqlIdentifier name, SqlIdentifier alias) {
        this.add(path, new AggregatePath.ColumnInfo(name, alias));
    }

    void add(RelationalPersistentProperty property, SqlIdentifier name, SqlIdentifier alias) {
        this.add(this.basePath.append(property), name, alias);
    }

    void add(AggregatePath path, AggregatePath.ColumnInfo columnInfo) {
        this.columnInfoMap.put(path, columnInfo);
    }

    AggregatePath.ColumnInfos build() {
        return new AggregatePath.ColumnInfos(this.columnInfoMap);
    }
}

